import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class InventoryMovementTypeController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ inventoryMovementTypeInstanceList: InventoryMovementType.list( params ), inventoryMovementTypeInstanceTotal: InventoryMovementType.count() ]
    }

    def show = {
        def inventoryMovementTypeInstance = InventoryMovementType.get( params.id )

        if(!inventoryMovementTypeInstance) {
            flash.message = "InventoryMovementType not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ inventoryMovementTypeInstance : inventoryMovementTypeInstance ] }
    }

    def delete = {
        def inventoryMovementTypeInstance = InventoryMovementType.get( params.id )
        if(inventoryMovementTypeInstance) {
            try {
                inventoryMovementTypeInstance.delete(flush:true)
                flash.message = "InventoryMovementType ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "InventoryMovementType ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "InventoryMovementType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def inventoryMovementTypeInstance = InventoryMovementType.get( params.id )

        if(!inventoryMovementTypeInstance) {
            flash.message = "InventoryMovementType not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ inventoryMovementTypeInstance : inventoryMovementTypeInstance ]
        }
    }

    def update = {
        def inventoryMovementTypeInstance = InventoryMovementType.get( params.id )
        if(inventoryMovementTypeInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(inventoryMovementTypeInstance.version > version) {
                    
                    inventoryMovementTypeInstance.errors.rejectValue("version", "inventoryMovementType.optimistic.locking.failure", "Another user has updated this InventoryMovementType while you were editing.")
                    render(view:'edit',model:[inventoryMovementTypeInstance:inventoryMovementTypeInstance])
                    return
                }
            }
            inventoryMovementTypeInstance.properties = params
            if(!inventoryMovementTypeInstance.hasErrors() && inventoryMovementTypeInstance.save(flush: true)) {
                flash.message = "InventoryMovementType ${params.id} updated"
                redirect(action:show,id:inventoryMovementTypeInstance.id)
            }
            else {
                render(view:'edit',model:[inventoryMovementTypeInstance:inventoryMovementTypeInstance])
            }
        }
        else {
            flash.message = "InventoryMovementType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def inventoryMovementTypeInstance = new InventoryMovementType()
        inventoryMovementTypeInstance.properties = params
        return ['inventoryMovementTypeInstance':inventoryMovementTypeInstance]
    }

    def save = {
        def inventoryMovementTypeInstance = new InventoryMovementType(params)
        if(!inventoryMovementTypeInstance.hasErrors() && inventoryMovementTypeInstance.save(flush: true)) {
            flash.message = "InventoryMovementType ${inventoryMovementTypeInstance.id} created"
            redirect(action:show,id:inventoryMovementTypeInstance.id)
        }
        else {
            render(view:'create',model:[inventoryMovementTypeInstance:inventoryMovementTypeInstance])
        }
    }
}
