

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Create Task</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><g:link class="list" action="list">Task List</g:link></span>
        </div>
        <div class="body">
            <h1>Create Task</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${taskInstance}">
            <div class="errors">
                <g:renderErrors bean="${taskInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form action="save" method="post" >
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'description','errors')}">
                                    <input type="text" maxlength="75" id="description" name="description" value="${fieldValue(bean:taskInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'comment','errors')}">
                                    <input type="text" id="comment" name="comment" value="${fieldValue(bean:taskInstance,field:'comment')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="targetStartDate">Target Start Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'targetStartDate','errors')}">
                                    <g:datePicker name="targetStartDate" value="${taskInstance?.targetStartDate}" precision="minute" ></g:datePicker>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="targetCompletionDate">Target Completion Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'targetCompletionDate','errors')}">
                                    <g:datePicker name="targetCompletionDate" value="${taskInstance?.targetCompletionDate}" precision="minute" ></g:datePicker>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="leadPerson">Lead Person:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'leadPerson','errors')}">
                                    <g:select optionKey="id" from="${Person.list()}" name="leadPerson.id" value="${taskInstance?.leadPerson?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskPriority">Task Priority:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskPriority','errors')}">
                                    <g:select optionKey="id" from="${TaskPriority.list()}" name="taskPriority.id" value="${taskInstance?.taskPriority?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskBudgetStatus">Task Budget Status:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskBudgetStatus','errors')}">
                                    <g:select optionKey="id" from="${TaskBudgetStatus.list()}" name="taskBudgetStatus.id" value="${taskInstance?.taskBudgetStatus?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskStatus">Task Status:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskStatus','errors')}">
                                    <g:select optionKey="id" from="${TaskStatus.list()}" name="taskStatus.id" value="${taskInstance?.taskStatus?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="parentTask">Parent Task:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'parentTask','errors')}">
                                    <g:select optionKey="id" from="${Task.list()}" name="parentTask.id" value="${taskInstance?.parentTask?.id}" noSelection="['null':'']"></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="primaryAsset">Primary Asset:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'primaryAsset','errors')}">
                                    <g:select optionKey="id" from="${Asset.list()}" name="primaryAsset.id" value="${taskInstance?.primaryAsset?.id}" noSelection="['null':'']"></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskRecurringSchedule">Task Recurring Schedule:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskRecurringSchedule','errors')}">
                                    <g:select optionKey="id" from="${TaskRecurringSchedule.list()}" name="taskRecurringSchedule.id" value="${taskInstance?.taskRecurringSchedule?.id}" noSelection="['null':'']"></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskProcedure">Task Procedure:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskProcedure','errors')}">
                                    <g:select optionKey="id" from="${TaskProcedure.list()}" name="taskProcedure.id" value="${taskInstance?.taskProcedure?.id}" noSelection="['null':'']"></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="approved">Approved:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'approved','errors')}">
                                    <g:checkBox name="approved" value="${taskInstance?.approved}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="scheduled">Scheduled:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'scheduled','errors')}">
                                    <g:checkBox name="scheduled" value="${taskInstance?.scheduled}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskGroup">Task Group:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskGroup','errors')}">
                                    <g:select optionKey="id" from="${TaskGroup.list()}" name="taskGroup.id" value="${taskInstance?.taskGroup?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskType">Task Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskType','errors')}">
                                    <g:select optionKey="id" from="${TaskType.list()}" name="taskType.id" value="${taskInstance?.taskType?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="trash">Trash:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'trash','errors')}">
                                    <g:checkBox name="trash" value="${taskInstance?.trash}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
