class AssetSubItemService {

    boolean transactional = false

    def create(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssetSubItem", params.id] ]
            return result
        }

        result.assetSubItemInstance = new AssetSubItem()
        result.assetSubItemInstance.properties = params

        // pass in an asset to link to if provided.
        if(params.asset?.id)
            result.assetInstance = Asset.get(params.asset.id)

        // success
        return result
    }

    def save(params) {
        AssetSubItem.withTransaction { status ->
            def result = [:]

            def fail = { Map m ->
                status.setRollbackOnly()
                if(result.assetSubItemInstance && m.field)
                    result.assetSubItemInstance.errors.rejectValue(m.field, m.code)
                result.error = [ code: m.code, args: ["AssetSubItem", params.id] ]
                return result
            }

            result.assetSubItemInstance = new AssetSubItem(params)

            if(params.asset?.id) {
                result.assetInstance = Asset.get(params.asset.id)

                if(!result.assetInstance)
                    return fail(code:"assetSubItem.asset.not.found")
            }

            if(result.assetSubItemInstance.hasErrors() || !result.assetSubItemInstance.save(flush: true))
                return fail(code:"default.create.failure")

            if(result.assetInstance)
                result.assetInstance.addToAssetSubItems(result.assetSubItemInstance)

            // Success.
            return result

        } //end withTransaction
    } // save()

} // end class