import grails.util.GrailsUtil

class BootStrap 
{
    def init = { servletContext ->

    println "**** BootStrap; GrailsUtil.environment: ${GrailsUtil.environment}"
    
        switch (GrailsUtil.environment)
        {
            case "development":
                        println "**** BootStrap detected development"
                        configureForDevelopment()
                        break
            case "test":
                        println "**** BootStrap detected test"
                        configureForTest()
                        break
            case "production":
                        println "**** BootStrap detected production"
                        configureForProduction()
                        break 
        }
    
    }

    def destroy = {
    }
    
    /*
        Tasks to do when Grails is running in each environment.
    */
    void configureForDevelopment()
    {
        println "BootStrap configureForDevelopment() called"
    
        //TypeOfPersonGroup
        new PersonGroupType(name:"Department").save()
        new PersonGroupType(name:"Contractor").save()
        new PersonGroupType(name:"ProjectTeam").save()
    
        //PersonGroup
        new PersonGroup(personGroupType:PersonGroupType.findByName("Department"),
                        name:"Electrical").save()
        new PersonGroup(personGroupType:PersonGroupType.get(2),
                        name:"Kewl AirCon Guys").save()
        new PersonGroup(personGroupType:PersonGroupType.get(3),
                        name:"openMim").save()
            
        //Person
        new Person(personGroup:PersonGroup.get(1),
                   firstName:"FirstNameTech1",
                   lastName:"LastNameTech1").save()
        new Person(personGroup:PersonGroup.get(2),
                   firstName:"Joe",
                   lastName:"Samples").save()
                
        //TaskGroup
        new TaskGroup(name:"Engineering",
                      description:"Engineering task group").save()
        new TaskGroup(name:"Production",
                      description:"Production task group").save()
        new TaskGroup(name:"NewProject(s)",
                      description:" ").save()
                      
        
        //Task
        new Task(taskGroup:TaskGroup.findByName("Engineering"),
                 person:Person.get(1),
                 name:"Check specific level sensor",
                 description:"Has been noted as problematic, try recallibrating",
                 scheduledDate: new Date(),
                 targetDate: new Date() ).save()
        new Task(taskGroup:TaskGroup.findByName("Production"),
                 person:Person.get(2),
                 name:"Production Report",
                 description:"Production report for specific production run or shift",
                 scheduledDate: new Date(),
                 targetDate: new Date() ).save()

        //EntryType
        new EntryType(name:"Fault").save()
        new EntryType(name:"WorkDone").save()
    
    }
    
    //---------------------------------------------------------
    void configureForTest()
    {
        println "BootStrap configureForTest() called"
    }
    
    //---------------------------------------------------------
    void configureForProduction()
    {
        println "BootStrap configureForProduction() called"
    }

}
