class AssetSubItem {

    AssetSubItem parentItem

    String name
    String description = ""
    boolean isActive = true

    static hasMany = [assets: Asset,
                                subItems: AssetSubItem,
                                maintenanceActions: MaintenanceAction,
                                assetSubItemExtendedAttributes: AssetSubItemExtendedAttribute]

    static belongsTo = [Asset, AssetSubItem]

    static constraints = {
        name(maxSize:50, blank:false)
        description(maxSize:100)
        isActive()
        parentItem(nullable:true)
    }

    String toString() {
        "${this.name}"
    }
}

