import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class TaskBudgetStatusController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ taskBudgetStatusInstanceList: TaskBudgetStatus.list( params ), taskBudgetStatusInstanceTotal: TaskBudgetStatus.count() ]
    }

    def show = {
        def taskBudgetStatusInstance = TaskBudgetStatus.get( params.id )

        if(!taskBudgetStatusInstance) {
            flash.message = "TaskBudgetStatus not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ taskBudgetStatusInstance : taskBudgetStatusInstance ] }
    }

    def delete = {
        def taskBudgetStatusInstance = TaskBudgetStatus.get( params.id )
        if(taskBudgetStatusInstance) {
            try {
                taskBudgetStatusInstance.delete(flush:true)
                flash.message = "TaskBudgetStatus ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "TaskBudgetStatus ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "TaskBudgetStatus not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def taskBudgetStatusInstance = TaskBudgetStatus.get( params.id )

        if(!taskBudgetStatusInstance) {
            flash.message = "TaskBudgetStatus not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ taskBudgetStatusInstance : taskBudgetStatusInstance ]
        }
    }

    def update = {
        def taskBudgetStatusInstance = TaskBudgetStatus.get( params.id )
        if(taskBudgetStatusInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(taskBudgetStatusInstance.version > version) {
                    
                    taskBudgetStatusInstance.errors.rejectValue("version", "taskBudgetStatus.optimistic.locking.failure", "Another user has updated this TaskBudgetStatus while you were editing.")
                    render(view:'edit',model:[taskBudgetStatusInstance:taskBudgetStatusInstance])
                    return
                }
            }
            taskBudgetStatusInstance.properties = params
            if(!taskBudgetStatusInstance.hasErrors() && taskBudgetStatusInstance.save(flush: true)) {
                flash.message = "TaskBudgetStatus ${params.id} updated"
                redirect(action:show,id:taskBudgetStatusInstance.id)
            }
            else {
                render(view:'edit',model:[taskBudgetStatusInstance:taskBudgetStatusInstance])
            }
        }
        else {
            flash.message = "TaskBudgetStatus not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def taskBudgetStatusInstance = new TaskBudgetStatus()
        taskBudgetStatusInstance.properties = params
        return ['taskBudgetStatusInstance':taskBudgetStatusInstance]
    }

    def save = {
        def taskBudgetStatusInstance = new TaskBudgetStatus(params)
        if(!taskBudgetStatusInstance.hasErrors() && taskBudgetStatusInstance.save(flush: true)) {
            flash.message = "TaskBudgetStatus ${taskBudgetStatusInstance.id} created"
            redirect(action:show,id:taskBudgetStatusInstance.id)
        }
        else {
            render(view:'create',model:[taskBudgetStatusInstance:taskBudgetStatusInstance])
        }
    }
}
