import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class ExtendedAttributeTypeController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ extendedAttributeTypeInstanceList: ExtendedAttributeType.list( params ), extendedAttributeTypeInstanceTotal: ExtendedAttributeType.count() ]
    }

    def show = {
        def extendedAttributeTypeInstance = ExtendedAttributeType.get( params.id )

        if(!extendedAttributeTypeInstance) {
            flash.message = "ExtendedAttributeType not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ extendedAttributeTypeInstance : extendedAttributeTypeInstance ] }
    }

    def delete = {
        def extendedAttributeTypeInstance = ExtendedAttributeType.get( params.id )
        if(extendedAttributeTypeInstance) {
            try {
                extendedAttributeTypeInstance.delete(flush:true)
                flash.message = "ExtendedAttributeType ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "ExtendedAttributeType ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "ExtendedAttributeType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def extendedAttributeTypeInstance = ExtendedAttributeType.get( params.id )

        if(!extendedAttributeTypeInstance) {
            flash.message = "ExtendedAttributeType not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ extendedAttributeTypeInstance : extendedAttributeTypeInstance ]
        }
    }

    def update = {
        def extendedAttributeTypeInstance = ExtendedAttributeType.get( params.id )
        if(extendedAttributeTypeInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(extendedAttributeTypeInstance.version > version) {
                    
                    extendedAttributeTypeInstance.errors.rejectValue("version", "extendedAttributeType.optimistic.locking.failure", "Another user has updated this ExtendedAttributeType while you were editing.")
                    render(view:'edit',model:[extendedAttributeTypeInstance:extendedAttributeTypeInstance])
                    return
                }
            }
            extendedAttributeTypeInstance.properties = params
            if(!extendedAttributeTypeInstance.hasErrors() && extendedAttributeTypeInstance.save(flush: true)) {
                flash.message = "ExtendedAttributeType ${params.id} updated"
                redirect(action:show,id:extendedAttributeTypeInstance.id)
            }
            else {
                render(view:'edit',model:[extendedAttributeTypeInstance:extendedAttributeTypeInstance])
            }
        }
        else {
            flash.message = "ExtendedAttributeType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def extendedAttributeTypeInstance = new ExtendedAttributeType()
        extendedAttributeTypeInstance.properties = params
        return ['extendedAttributeTypeInstance':extendedAttributeTypeInstance]
    }

    def save = {
        def extendedAttributeTypeInstance = new ExtendedAttributeType(params)
        if(!extendedAttributeTypeInstance.hasErrors() && extendedAttributeTypeInstance.save(flush: true)) {
            flash.message = "ExtendedAttributeType ${extendedAttributeTypeInstance.id} created"
            redirect(action:show,id:extendedAttributeTypeInstance.id)
        }
        else {
            render(view:'create',model:[extendedAttributeTypeInstance:extendedAttributeTypeInstance])
        }
    }
}
