import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AssetSubItemDetailedController extends BaseController {
    
    def index = { redirect(controller: "assetDetailed", params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def show = {
        def assetSubItemInstance = AssetSubItem.get( params.id )

        if(!assetSubItemInstance) {
            flash.message = "AssetSubItem not found with id ${params.id}"
            redirect(controller: "assetDetailed", action: "search")
        }
        else { return [ assetSubItemInstance : assetSubItemInstance ] }
    }

    def delete = {
        def assetSubItemInstance = AssetSubItem.get( params.id )
        if(assetSubItemInstance) {
            try {
                assetSubItemInstance.delete(flush:true)
                flash.message = "AssetSubItem ${params.id} deleted"
                redirect(controller: "assetDetailed", action: "search")
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "AssetSubItem ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "AssetSubItem not found with id ${params.id}"
            redirect(controller: "assetDetailed", action: "search")
        }
    }

    def edit = {
        def assetSubItemInstance = AssetSubItem.get( params.id )

        if(!assetSubItemInstance) {
            flash.message = "AssetSubItem not found with id ${params.id}"
            redirect(controller: "assetDetailed", action: "search")
        }
        else {
            return [ assetSubItemInstance : assetSubItemInstance ]
        }
    }

    def update = {
        def assetSubItemInstance = AssetSubItem.get( params.id )
        if(assetSubItemInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(assetSubItemInstance.version > version) {

                    assetSubItemInstance.errors.rejectValue("version", "assetSubItem.optimistic.locking.failure", "Another user has updated this AssetSubItem while you were editing.")
                    render(view:'edit',model:[assetSubItemInstance:assetSubItemInstance])
                    return
                }
            }

            assetSubItemInstance.properties = params

//             if(!assetSubItemInstance.asset && !assetSubItemInstance.parentItem) {
//                 flash.message = "Either an asset or parentItem is required."
//                 render(view:'edit',model:[assetSubItemInstance:assetSubItemInstance])
//                 return
//             }
// 
//             if(assetSubItemInstance.asset && assetSubItemInstance.parentItem) {
//             flash.message = "Both an asset and parentItem may not be specified at the same time."
//                 render(view:'edit',model:[parentItem:parentItem])
//                 return
//             }

            if(!assetSubItemInstance.hasErrors() && assetSubItemInstance.save(flush: true)) {
                flash.message = "AssetSubItem ${params.id} updated"

                if(assetSubItemInstance.assets)
                    redirect(controller: "assetDetailed", action:"show", id: assetSubItemInstance.assets.toArray()[0].id)
                else {
                    //Get the top parentItem.
                    def parentItem = assetSubItemInstance.parentItem
                    def i = 0
                    while(parentItem?.parentItem) {
                        parentItem = parentItem.parentItem
                        // Protect against infinite recurrsion.
                        i++
                        if(i > 100)
                            break
                    }

                    if(parentItem?.assets)
                        redirect(controller: "assetDetailed", action:"show", id: parentItem.assets.toArray()[0].id)
                    else
                        redirect(action:"show", id: assetSubItemInstance.id) // End stop if all else fails.
                }
            }
            else {
                render(view:'edit',model:[assetSubItemInstance:assetSubItemInstance])
            }
        }
        else {
            flash.message = "AssetSubItem not found with id ${params.id}"
            redirect(controller: "assetDetailed", action: "search")
        }
    }

    def create = {
        def assetSubItemInstance = new AssetSubItem()
        assetSubItemInstance.properties = params
        return ['assetSubItemInstance':assetSubItemInstance]
    }

    def save = {
        def assetSubItemInstance = new AssetSubItem(params)

//         if(!assetSubItemInstance.asset && !assetSubItemInstance.parentItem) {
//             flash.message = "Either an asset or parentItem is required."
//             render(view:'create',model:[assetSubItemInstance:assetSubItemInstance])
//             return
//         }
// 
//         if(assetSubItemInstance.asset && assetSubItemInstance.parentItem) {
//             flash.message = "Both an asset and parentItem may not be specified at the same time."
//             render(view:'create',model:[assetSubItemInstance:assetSubItemInstance])
//             return
//         }

        if(!assetSubItemInstance.hasErrors() && assetSubItemInstance.save(flush: true)) {
            flash.message = "AssetSubItem ${assetSubItemInstance.id} created"

            if(assetSubItemInstance.assets)
                redirect(controller: "assetDetailed", action:"show", id: assetSubItemInstance.assets.toArray()[0].id)
            else {
                //Get the top parentItem.
                def parentItem = assetSubItemInstance.parentItem
                def i = 0
                while(parentItem?.parentItem) {
                    parentItem = parentItem.parentItem
                    // Protect against infinite recurrsion.
                    i++
                    if(i > 100)
                        break
                }

                if(parentItem?.assets)
                    redirect(controller: "assetDetailed", action:"show", id: parentItem.assets.toArray()[0].id)
                else
                    redirect(action:"show", id: assetSubItemInstance.id) // End stop if all else fails.
            }

        }
        else {
            render(view:'create',model:[assetSubItemInstance:assetSubItemInstance])
        }
    } // end save()

} // end class
