class Section {

    Site site
    Department department

    String name
    String description = ""
    boolean isActive = true

    static hasMany = [assets: Asset,
                                maintenanceActions: MaintenanceAction,
                                sectionExtendedAttributes: SectionExtendedAttribute]

    static belongsTo = [Site]

    static constraints = {
        name(maxSize:50, unique:true, blank:false)
        description(maxSize:100)
        isActive()
    }

    String toString() {
        "${this.name}"
    }
}

