class AssetSubItem {

    Asset asset
    AssetSubItem parentItem

    String name
    String description = ""
    boolean isActive = true

    static hasMany = [subItems: AssetSubItem,
                                maintenanceActions: MaintenanceAction,
                                assetSubItemExtendedAttributes: AssetSubItemExtendedAttribute]

    static belongsTo = [Asset, AssetSubItem]

    static constraints = {
        name(maxSize:50, blank:false)
        description(maxSize:100)
        isActive()
        asset(nullable:true)
        parentItem(nullable:true)
    }

    String toString() {
        "${this.name}"
    }
}

