import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AssignedPersonDetailedController extends BaseController {

    def assignedPersonService

    def index = {
        flash.message = g.message(code: "assignedPerson.task.not.found")
        redirect(controller:"taskDetailed", action:"search")
    }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def delete = {
        def result = assignedPersonService.delete(params)

        if(!result.error) {
            flash.message = g.message(code: "default.delete.success", args: ["AssignedPerson", params.id])
            redirect(controller:"taskDetailed", action:"show", id: params.task?.id)
            return
        }

        flash.message = g.message(code: result.error.code, args: result.error.args)

        if(result.error.code == "default.not.found") {
            redirect(controller:"taskDetailed", action:"show", id: params.task?.id)
            return
        }

        redirect(action:show, id: params.id)
    }

    def edit = {
        def result = assignedPersonService.edit(params)

        if(!result.error) {
            return [assignedPersonInstance: result.assignedPersonInstance,
                            person: result.person,
                            groupsForPerson: result.groupsForPerson]
        }

        flash.message = g.message(code: result.error.code, args: result.error.args)

        redirect(controller:"taskDetailed", action:"show", id: params.task?.id)

    }

    def update = {
        def result = assignedPersonService.update(params)

        if(!result.error) {
            flash.message = g.message(code: "default.update.success", args: ["AssignedPerson", params.id])
            redirect(controller:"taskDetailed", action:"show", id: result.assignedPersonInstance.task.id)
            return
        }

        if(result.error.code == "default.not.found") {
            flash.message = g.message(code: result.error.code, args: result.error.args)
            redirect(controller:"taskDetailed", action:"show", id: params.task?.id)
            return
        }

        if(result.error.code == "person.not.found") {
            flash.message = g.message(code: result.error.code, args: result.error.args)
            redirect(action:"edit", id: params.id)
            return
        }

        render(view:'edit', model:[assignedPersonInstance: result.assignedPersonInstance.attach(),
                                                person: result.person.attach(),
                                                groupsForPerson: result.groupsForPerson])
    }

    def create = {
        def result = assignedPersonService.create(params)

        if(!result.error) {
            return [assignedPersonInstance: result.assignedPersonInstance,
                            person: result.person,
                            groupsForPerson: result.groupsForPerson]
        }

        if(result.error.code == "assignedPerson.task.not.found") {
            flash.message = g.message(code: result.error.code, args: result.error.args)
            redirect(controller: "taskDetailed", action: "search")
            return
        }

        flash.message = g.message(code: result.error.code, args: result.error.args)
        redirect(controller:"taskDetailed", action:"show", id: params.task?.id)
    }

    def save = {
        def result = assignedPersonService.save(params)

        if(!result.error) {
            flash.message = g.message(code: "default.create.success", args: ["AssignedPerson", result.assignedPersonInstance.id])
            redirect(controller:"taskDetailed", action:"show", id: result.assignedPersonInstance.task.id)
            return
        }

        if(result.error.code == "person.not.found") {
            flash.message = g.message(code: result.error.code, args: result.error.args)
            redirect(action:"create", params:["task.id": params.task?.id])
            return
        }

        render(view:'create', model:[assignedPersonInstance: result.assignedPersonInstance,
                                                person: result.person.attach(),
                                                groupsForPerson: result.groupsForPerson])
    }

    def groupsForPerson = {
        def result = assignedPersonService.groupsForPerson(params)

        if(!result.error) {
            render ( template:"groupsForPerson",
                            model: [person: result.person, groupsForPerson: result.groupsForPerson] )
            return
        }

        render {
            div(id:"groupsForPerson", g.message(code: result.error.code, args: result.error.args) )
        }

    }

}
