import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AssetExtendedAttributeTypeController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ assetExtendedAttributeTypeInstanceList: AssetExtendedAttributeType.list( params ), assetExtendedAttributeTypeInstanceTotal: AssetExtendedAttributeType.count() ]
    }

    def show = {
        def assetExtendedAttributeTypeInstance = AssetExtendedAttributeType.get( params.id )

        if(!assetExtendedAttributeTypeInstance) {
            flash.message = "AssetExtendedAttributeType not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ assetExtendedAttributeTypeInstance : assetExtendedAttributeTypeInstance ] }
    }

    def delete = {
        def assetExtendedAttributeTypeInstance = AssetExtendedAttributeType.get( params.id )
        if(assetExtendedAttributeTypeInstance) {
            try {
                assetExtendedAttributeTypeInstance.delete(flush:true)
                flash.message = "AssetExtendedAttributeType ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "AssetExtendedAttributeType ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "AssetExtendedAttributeType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def assetExtendedAttributeTypeInstance = AssetExtendedAttributeType.get( params.id )

        if(!assetExtendedAttributeTypeInstance) {
            flash.message = "AssetExtendedAttributeType not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ assetExtendedAttributeTypeInstance : assetExtendedAttributeTypeInstance ]
        }
    }

    def update = {
        def assetExtendedAttributeTypeInstance = AssetExtendedAttributeType.get( params.id )
        if(assetExtendedAttributeTypeInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(assetExtendedAttributeTypeInstance.version > version) {
                    
                    assetExtendedAttributeTypeInstance.errors.rejectValue("version", "assetExtendedAttributeType.optimistic.locking.failure", "Another user has updated this AssetExtendedAttributeType while you were editing.")
                    render(view:'edit',model:[assetExtendedAttributeTypeInstance:assetExtendedAttributeTypeInstance])
                    return
                }
            }
            assetExtendedAttributeTypeInstance.properties = params
            if(!assetExtendedAttributeTypeInstance.hasErrors() && assetExtendedAttributeTypeInstance.save(flush: true)) {
                flash.message = "AssetExtendedAttributeType ${params.id} updated"
                redirect(action:show,id:assetExtendedAttributeTypeInstance.id)
            }
            else {
                render(view:'edit',model:[assetExtendedAttributeTypeInstance:assetExtendedAttributeTypeInstance])
            }
        }
        else {
            flash.message = "AssetExtendedAttributeType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def assetExtendedAttributeTypeInstance = new AssetExtendedAttributeType()
        assetExtendedAttributeTypeInstance.properties = params
        return ['assetExtendedAttributeTypeInstance':assetExtendedAttributeTypeInstance]
    }

    def save = {
        def assetExtendedAttributeTypeInstance = new AssetExtendedAttributeType(params)
        if(!assetExtendedAttributeTypeInstance.hasErrors() && assetExtendedAttributeTypeInstance.save(flush: true)) {
            flash.message = "AssetExtendedAttributeType ${assetExtendedAttributeTypeInstance.id} created"
            redirect(action:show,id:assetExtendedAttributeTypeInstance.id)
        }
        else {
            render(view:'create',model:[assetExtendedAttributeTypeInstance:assetExtendedAttributeTypeInstance])
        }
    }
}
