import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AssemblyController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ assemblyInstanceList: Assembly.list( params ), assemblyInstanceTotal: Assembly.count() ]
    }

    def show = {
        def assemblyInstance = Assembly.get( params.id )

        if(!assemblyInstance) {
            flash.message = "Assembly not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ assemblyInstance : assemblyInstance ] }
    }

    def delete = {
        def assemblyInstance = Assembly.get( params.id )
        if(assemblyInstance) {
            try {
                assemblyInstance.delete(flush:true)
                flash.message = "Assembly ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "Assembly ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "Assembly not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def assemblyInstance = Assembly.get( params.id )

        if(!assemblyInstance) {
            flash.message = "Assembly not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ assemblyInstance : assemblyInstance ]
        }
    }

    def update = {
        def assemblyInstance = Assembly.get( params.id )
        if(assemblyInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(assemblyInstance.version > version) {
                    
                    assemblyInstance.errors.rejectValue("version", "assembly.optimistic.locking.failure", "Another user has updated this Assembly while you were editing.")
                    render(view:'edit',model:[assemblyInstance:assemblyInstance])
                    return
                }
            }
            assemblyInstance.properties = params
            if(!assemblyInstance.hasErrors() && assemblyInstance.save(flush: true)) {
                flash.message = "Assembly ${params.id} updated"
                redirect(action:show,id:assemblyInstance.id)
            }
            else {
                render(view:'edit',model:[assemblyInstance:assemblyInstance])
            }
        }
        else {
            flash.message = "Assembly not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def assemblyInstance = new Assembly()
        assemblyInstance.properties = params
        return ['assemblyInstance':assemblyInstance]
    }

    def save = {
        def assemblyInstance = new Assembly(params)
        if(!assemblyInstance.hasErrors() && assemblyInstance.save(flush: true)) {
            flash.message = "Assembly ${assemblyInstance.id} created"
            redirect(action:show,id:assemblyInstance.id)
        }
        else {
            render(view:'create',model:[assemblyInstance:assemblyInstance])
        }
    }
}
