

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit InventoryStore</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><g:link class="list" action="list">InventoryStore List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New InventoryStore</g:link></span>
        </div>
        <div class="body">
            <h1>Edit InventoryStore</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${inventoryStoreInstance}">
            <div class="errors">
                <g:renderErrors bean="${inventoryStoreInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${inventoryStoreInstance?.id}" />
                <input type="hidden" name="version" value="${inventoryStoreInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryStoreInstance,field:'name','errors')}">
                                    <input type="text" maxlength="50" id="name" name="name" value="${fieldValue(bean:inventoryStoreInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryStoreInstance,field:'description','errors')}">
                                    <input type="text" maxlength="100" id="description" name="description" value="${fieldValue(bean:inventoryStoreInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryLocations">Inventory Locations:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryStoreInstance,field:'inventoryLocations','errors')}">
                                    
<ul>
<g:each var="i" in="${inventoryStoreInstance?.inventoryLocations?}">
    <li><g:link controller="inventoryLocation" action="show" id="${i.id}">${i?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="inventoryLocation" params="['inventoryStore.id':inventoryStoreInstance?.id]" action="create">Add InventoryLocation</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryStoreInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${inventoryStoreInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="site">Site:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryStoreInstance,field:'site','errors')}">
                                    <g:select optionKey="id" from="${Site.list()}" name="site.id" value="${inventoryStoreInstance?.site?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
