import grails.util.GrailsUtil

class BootStrap 
{
    def init = { servletContext ->

    println "**** BootStrap; GrailsUtil.environment: ${GrailsUtil.environment}"
    
        switch (GrailsUtil.environment)
        {
            case "development":
                        println "**** BootStrap detected development"
                        configureForDevelopment()
                        break
            case "test":
                        println "**** BootStrap detected test"
                        configureForTest()
                        break
            case "production":
                        println "**** BootStrap detected production"
                        configureForProduction()
                        break 
        }
    
    }

    def destroy = {
    }
    
    /*
        Tasks to do when Grails is running in each environment.
    */
    void configureForDevelopment()
    {
        println "BootStrap configureForDevelopment() called"
    
        //TypeOfPersonGroup
        new PersonGroupType(name:"Department").save()
        println "PersonGroup = ${PersonGroupType.get(1)}"
        new PersonGroupType(name:"Contractor").save()
        new PersonGroupType(name:"ProjectTeam").save()
    
        //PersonGroup
        new PersonGroup(PersonGroupType:PersonGroupType.findByName("Department"), name:"Electrical").save()
        new PersonGroup(
            PersonGroupType:PersonGroupType.get(2),
            name:"Kewl AirCon Guys").save()
        new PersonGroup(
            PersonGroupType:PersonGroupType.get(3),
            name:"openMim").save()
            
        //Person
        new Person(personGroup:PersonGroup.get(1),
            firstName:"FirstNameTech1",
            lastName:"LastNameTech1").save()
        new Person(personGroup:PersonGroup.get(2),
                    firstName:"Joe",
                    lastName:"Samples").save()
    
    }
    
    //---------------------------------------------------------
    void configureForTest()
    {
        println "BootStrap configureForTest() called"
    }
    
    //---------------------------------------------------------
    void configureForProduction()
    {
        println "BootStrap configureForProduction() called"
    }

}
