import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class InventoryMovementDetailedController extends BaseController {

    def inventoryMovementService

    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST']

    def list = {
        flash.message = flash.message
        redirect(controller:"taskDetailed", action:"search")
    }

    def show = {
        def inventoryMovementInstance = InventoryMovement.get( params.id )

        if(!inventoryMovementInstance) {
            flash.message = "InventoryMovement not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ inventoryMovementInstance : inventoryMovementInstance ] }
    }

    /**
    * List the inventory movements for an InventoryItem.
    * @param params.id The id of an existing inventory item.
    */
    def listInventoryMovements = {
        def inventoryItemInstance = InventoryItem.get(params.id)

        if(!inventoryItemInstance) {
            flash.message = "Inventory item not found with id ${params.id}"
            redirect(controller:'inventoryItemDetailed', action: 'search')
        }

        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        def inventoryMovementList = InventoryMovement.findAllByInventoryItem(inventoryItemInstance, params)
        def inventoryMovementListTotal = InventoryMovement.countByInventoryItem(inventoryItemInstance)

        [ inventoryMovementList: inventoryMovementList,
            inventoryMovementListTotal:  inventoryMovementListTotal,
            inventoryItemInstance: inventoryItemInstance]
    }

    def delete = {
        def result = inventoryMovementService.reverseMove(params)

        if(!result.error) {
            flash.message = "InventoryMovement ${params.id} deleted"
            redirect(controller:"taskDetailed", action:"show", id:result.taskId)
        }
        else {
            if(result.inventoryMovementInstance) {
                render(view:'show',model:[inventoryMovementInstance:result.inventoryMovementInstance.attach()])
            }
            else {
                flash.message = "Could not delete inventory movement."
                redirect(controller:"taskDetailed", action:"search")
            }
        }
    }

    def create = {
        if(!params.task?.id) {
            flash.message = "Please select a task, then the Inventory tab."
            redirect(controller:"taskDetailed", action:"search")
        }
        def inventoryMovementInstance = new InventoryMovement()
        inventoryMovementInstance.properties = params
        return ['inventoryMovementInstance':inventoryMovementInstance]
    }

    def save = {
        def result = inventoryMovementService.move(params)

        if(!result.error) {
            flash.message = "Inventory Movement for ${result.inventoryMovementInstance.inventoryItem.name} created."
            redirect(controller:"taskDetailed", action:"show", id: result.taskId)
        }
        else {
            if(result.inventoryMovementInstance) {
                render(view:'create',model:[inventoryMovementInstance:result.inventoryMovementInstance])
            }
            else {
                flash.message = "Could not create inventory movement."
                redirect(controller:"taskDetailed", action:"search", id:result.taskId)
            }

        }
    }

}
