import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class ComponentItemController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ componentItemInstanceList: ComponentItem.list( params ), componentItemInstanceTotal: ComponentItem.count() ]
    }

    def show = {
        def componentItemInstance = ComponentItem.get( params.id )

        if(!componentItemInstance) {
            flash.message = "ComponentItem not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ componentItemInstance : componentItemInstance ] }
    }

    def delete = {
        def componentItemInstance = ComponentItem.get( params.id )
        if(componentItemInstance) {
            try {
                componentItemInstance.delete(flush:true)
                flash.message = "ComponentItem ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "ComponentItem ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "ComponentItem not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def componentItemInstance = ComponentItem.get( params.id )

        if(!componentItemInstance) {
            flash.message = "ComponentItem not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ componentItemInstance : componentItemInstance ]
        }
    }

    def update = {
        def componentItemInstance = ComponentItem.get( params.id )
        if(componentItemInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(componentItemInstance.version > version) {
                    
                    componentItemInstance.errors.rejectValue("version", "componentItem.optimistic.locking.failure", "Another user has updated this ComponentItem while you were editing.")
                    render(view:'edit',model:[componentItemInstance:componentItemInstance])
                    return
                }
            }
            componentItemInstance.properties = params
            if(!componentItemInstance.hasErrors() && componentItemInstance.save(flush: true)) {
                flash.message = "ComponentItem ${params.id} updated"
                redirect(action:show,id:componentItemInstance.id)
            }
            else {
                render(view:'edit',model:[componentItemInstance:componentItemInstance])
            }
        }
        else {
            flash.message = "ComponentItem not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def componentItemInstance = new ComponentItem()
        componentItemInstance.properties = params
        return ['componentItemInstance':componentItemInstance]
    }

    def save = {
        def componentItemInstance = new ComponentItem(params)
        if(!componentItemInstance.hasErrors() && componentItemInstance.save(flush: true)) {
            flash.message = "ComponentItem ${componentItemInstance.id} created"
            redirect(action:show,id:componentItemInstance.id)
        }
        else {
            render(view:'create',model:[componentItemInstance:componentItemInstance])
        }
    }
}
