security {

    def authenticateService

	// See DefaultSecurityConfig.groovy for all settable/overridable properties

	active = true

	loginUserDomainClass = "Person"
    userName = 'loginName'
    password = 'password'
    enabled = 'isActive'

	authorityDomainClass = "Authority"

    // Required if we want to run "grails generate-manager"
    // Which recreates the controller and views, so save the views!
//     requestMapClass = 'Requestmap'

    // The whole application relies on controllerAnnotations and the static rules bellow.
    useRequestMapDomainClass = false
    useControllerAnnotations = true

    // Set true especially if used across the internet.
    forceHttps = 'false'

    // Pessimistic locking, deny access to all URLs that don't 
    // have an applicable URL-Role configuration.
    // This forces us to set an annotation, static rule or
    // extend BaseController and prevents accidentally leaving pages open.
    controllerAnnotationsRejectIfNoRule = true

    // Static rules for controllers, actions and urls.
    // Since we are using pessimistic locking we have to set some things
    // here but most security should be set in the controllers.
    controllerAnnotationStaticRules = [
    '/': ['IS_AUTHENTICATED_FULLY'],
    '/index.gsp': ['IS_AUTHENTICATED_FULLY'],
    '/css/*': ['IS_AUTHENTICATED_ANONYMOUSLY'],
    '/images/**': ['IS_AUTHENTICATED_ANONYMOUSLY'],
    '/js/**': ['IS_AUTHENTICATED_ANONYMOUSLY'],
    '/plugins/**': ['IS_AUTHENTICATED_FULLY'],
    '/classDiagram*': ['IS_AUTHENTICATED_FULLY'],
    '/classDiagram/**': ['IS_AUTHENTICATED_FULLY'],
    '/login*': ['IS_AUTHENTICATED_ANONYMOUSLY'],
    '/login/**': ['IS_AUTHENTICATED_ANONYMOUSLY'],
    '/logout*': ['IS_AUTHENTICATED_FULLY'],
    '/logout/**': ['IS_AUTHENTICATED_FULLY'],
    '/image*': ['IS_AUTHENTICATED_FULLY'],
    '/image/**': ['IS_AUTHENTICATED_FULLY']
    ]

    // Always call the welcome action so that bookmarks are not used, a
    // welcome message can be populated and the sessionTimeout can be set.
    defaultTargetUrl = '/appCore/welcome'
    alwaysUseDefaultTargetUrl = true

    // User caching, turned this off so that password changes take effect.
    // It would appear that user is still in the session as logout/login
    // is still required for role changes to take effect.
    // If this option causes high database load try:
    //  import org.acegisecurity.providers.dao.DaoAuthenticationProvider
    //  import org.acegisecurity.context.SecurityContextHolder
    //  DaoAuthenticationProvider daoAuthenticationProvider 
    //  def user = SecurityContextHolder.context.authentication.principal.username 
    //  daoAuthenticationProvider.userCache.removeUserFromCache(user)
    //  in logout controller and perhaps on password change and role change.
    cacheUsers = false

//    // Listen for events and run the closure(s) that follow.
//    // Unfortunately the session is not available yet so many things can't be done here, use a defaultTargetUrl and controller.
//    useSecurityEventListener = true
//
//    onAuthenticationSuccessEvent = { e, appCtx ->
//        def p = e.source.principal
//        def personInstance = Person.findByLoginName(p.username)
//        println p.username
//        println personInstance.loginName
//        println personInstance.firstName
//    }

}
