import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AssetDetailedController extends BaseController {

    def filterService

    def index = { redirect(action:search,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ assetInstanceList: Asset.list( params ), assetInstanceTotal: Asset.count() ]
    }

    def search = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)

        // Quick Search:
        if(!params.filter) {
           return [ assetInstanceList: Asset.list( params ), assetInstanceTotal: Asset.count() ]
        }
        // filterPane:
        return[ assetInstanceList: filterService.filter( params, Asset ),
                assetInstanceTotal: filterService.count( params, Asset ),
                filterParams: com.zeddware.grails.plugins.filterpane.FilterUtils.extractFilterParams(params),
                params:params ]
    }

    def show = {
        
        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Show)
        { params.action='show' }
        
        def assetInstance = Asset.get( params.id )

        if(!assetInstance) {
            flash.message = "Asset not found with id ${params.id}"
            redirect(action:search)
        }
        else { return [ assetInstance : assetInstance ] }
    }

    def delete = {
        def assetInstance = Asset.get( params.id )
        if(assetInstance) {
            try {
                assetInstance.delete(flush:true)
                flash.message = "Asset ${params.id} deleted"
                redirect(action:search)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "Asset ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "Asset not found with id ${params.id}"
            redirect(action:search)
        }
    }

    def edit = {
        
        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Edit)
        { params.action='edit' }
        
        def assetInstance = Asset.get( params.id )

        if(!assetInstance) {
            flash.message = "Asset not found with id ${params.id}"
            redirect(action:search)
        }
        else {
            return [ assetInstance : assetInstance ]
        }
    }

    def update = {
        def assetInstance = Asset.get( params.id )
        if(assetInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(assetInstance.version > version) {
                    
                    assetInstance.errors.rejectValue("version", "asset.optimistic.locking.failure", "Another user has updated this Asset while you were editing.")
                    render(view:'edit',model:[assetInstance:assetInstance])
                    return
                }
            }
            assetInstance.properties = params
            if(!assetInstance.hasErrors() && assetInstance.save()) {
                flash.message = "Asset ${params.id} updated"
                redirect(action:show,id:assetInstance.id)
            }
            else {
                render(view:'edit',model:[assetInstance:assetInstance])
            }
        }
        else {
            flash.message = "Asset not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def assetInstance = new Asset()
        assetInstance.properties = params
        return ['assetInstance':assetInstance]
    }

    def save = {
        def assetInstance = new Asset(params)
        if(!assetInstance.hasErrors() && assetInstance.save()) {
            flash.message = "Asset ${assetInstance.id} created"
            redirect(action:show,id:assetInstance.id)
        }
        else {
            render(view:'create',model:[assetInstance:assetInstance])
        }
    }
}
