

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit AssetType</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${resource(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">AssetType List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New AssetType</g:link></span>
        </div>
        <div class="body">
            <h1>Edit AssetType</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${assetTypeInstance}">
            <div class="errors">
                <g:renderErrors bean="${assetTypeInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${assetTypeInstance?.id}" />
                <input type="hidden" name="version" value="${assetTypeInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="assemblies">Assemblies:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetTypeInstance,field:'assemblies','errors')}">
                                    
<ul>
<g:each var="a" in="${assetTypeInstance?.assemblies?}">
    <li><g:link controller="assembly" action="show" id="${a.id}">${a?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="assembly" params="['assetType.id':assetTypeInstance?.id]" action="create">Add Assembly</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="assets">Assets:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetTypeInstance,field:'assets','errors')}">
                                    
<ul>
<g:each var="a" in="${assetTypeInstance?.assets?}">
    <li><g:link controller="asset" action="show" id="${a.id}">${a?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="asset" params="['assetType.id':assetTypeInstance?.id]" action="create">Add Asset</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="costCode">Cost Code:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetTypeInstance,field:'costCode','errors')}">
                                    <input type="text" id="costCode" name="costCode" value="${fieldValue(bean:assetTypeInstance,field:'costCode')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetTypeInstance,field:'description','errors')}">
                                    <input type="text" id="description" name="description" value="${fieldValue(bean:assetTypeInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetTypeInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${assetTypeInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="maintenanceActions">Maintenance Actions:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetTypeInstance,field:'maintenanceActions','errors')}">
                                    
<ul>
<g:each var="m" in="${assetTypeInstance?.maintenanceActions?}">
    <li><g:link controller="maintenanceAction" action="show" id="${m.id}">${m?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="maintenanceAction" params="['assetType.id':assetTypeInstance?.id]" action="create">Add MaintenanceAction</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetTypeInstance,field:'name','errors')}">
                                    <input type="text" id="name" name="name" value="${fieldValue(bean:assetTypeInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
