import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class EntryDetailedController extends BaseController {

    def authenticateService
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        if(!params.max) params.max = 10
        [ entryInstanceList: Entry.list( params ) ]
    }

    def show = {
        def entryInstance = Entry.get( params.id )

        if(!entryInstance) {
            flash.message = "Entry not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ entryInstance : entryInstance ] }
    }

    def delete = {
        def entryInstance = Entry.get( params.id )
        if(entryInstance) {
            if(entryInstance.enteredBy.loginName == authenticateService.userDomain().loginName) {
                entryInstance.delete()
                flash.message = "Entry ${params.id} deleted"
                redirect(action:list)
            }
            else {
                flash.message = "You may only delete your own entries."
                redirect(action:show,id:entryInstance.id)
            }

        }
        else {
            flash.message = "Entry not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def entryInstance = Entry.get( params.id )
        if(!entryInstance) {
                flash.message = "Entry not found with id ${params.id}"
                redirect(action:list)
        }
        else {

            if(entryInstance.enteredBy.loginName == authenticateService.userDomain().loginName) {
                return [ entryInstance : entryInstance ]
            }
            else {
                flash.message = "You may only edit your own entries."
                redirect(action:show,id:entryInstance.id)
            }

        }
    }

    def update = {
        def entryInstance = Entry.get( params.id )
        if(entryInstance) {
            entryInstance.properties = params
            if(!entryInstance.hasErrors() && entryInstance.save()) {
                flash.message = "Entry ${params.id} updated"
                redirect(action:show,id:entryInstance.id)
            }
            else {
                render(view:'edit',model:[entryInstance:entryInstance])
            }
        }
        else {
            flash.message = "Entry not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        try {
            def taskInstance = Task.get(params.taskInstance.id)
            def entryInstance = new Entry()
            entryInstance.task = taskInstance
            return ['entryInstance':entryInstance]
        }
        catch(Exception e) {
            flash.message = "Please select a task, then 'Add Entry'"
            redirect(controller:"taskDetailed", action:"list")
        }
    }

    def save = {
        def entryInstance = new Entry(params)

        entryInstance.enteredBy = Person.get(authenticateService.userDomain().id)
        if(!entryInstance.hasErrors() && entryInstance.save()) {
            flash.message = "Entry ${entryInstance.id} created"
            redirect(controller:"taskDetailed", action:"show", id: params.task.id)
        }
        else {
            render(view:'create',model:[entryInstance:entryInstance])
        }
    }
}
