<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Create Task</title>
        <nav:resources override="true"/>
    </head>
    <body onload="document.createTaskForm.description.focus();">
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${taskInstance}">
            <div class="errors">
                <g:renderErrors bean="${taskInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form id='createTaskForm' name='createTaskForm' action="save" method="post" >
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'description','errors')}">
                                    <input type="text"  class="description" maxlength="75" id="description" name="description" value="${fieldValue(bean:taskInstance,field:'description')}"/>
                                    <g:helpBalloon class="helpballoon" code="task.description" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'comment','errors')}">
                                    <textarea  rows="5" cols="40" name="comment">${fieldValue(bean:taskInstance, field:'comment')}</textarea>
                                    <g:helpBalloon class="helpballoon" code="task.comment" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="targetStartDate">Target Start Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'targetStartDate','errors')}">
                                    <g:datePicker name="targetStartDate" value="${taskInstance?.targetStartDate}" precision="day"></g:datePicker>
                                    <g:helpBalloon class="helpballoon" code="task.targetStartDate" />
                                </td>
                            </tr> 

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="targetCompletionDate">Target Completion Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'targetCompletionDate','errors')}">
                                    <g:datePicker name="targetCompletionDate" value="${taskInstance?.targetCompletionDate}" precision="day"></g:datePicker>
                                    <g:helpBalloon class="helpballoon" code="task.targetCompletionDate" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="leadPerson">Lead Person:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'leadPerson','errors')}">
                                    <g:select optionKey="id" from="${Person.list()}" name="leadPerson.id" value="${taskInstance?.leadPerson?.id}" ></g:select>
                                    <g:helpBalloon code="task.leadPerson" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskPriority">Task Priority:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskPriority','errors')}">
                                    <g:select optionKey="id" from="${TaskPriority.list()}" name="taskPriority.id" value="${taskInstance?.taskPriority?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskStatus">Task Status:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskStatus','errors')}">
                                    <g:select optionKey="id" from="${TaskStatus.list()}" name="taskStatus.id" value="${taskInstance?.taskStatus?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${taskInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isApproved">Is Approved:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'isApproved','errors')}">
                                    <g:checkBox name="isApproved" value="${taskInstance?.isApproved}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isScheduled">Is Scheduled:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'isScheduled','errors')}">
                                    <g:checkBox name="isScheduled" value="${taskInstance?.isScheduled}" ></g:checkBox>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="parentTask">Parent Task:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'parentTask','errors')}">
                                    <g:select optionKey="id" from="${Task.list()}" name="parentTask.id" value="${taskInstance?.parentTask?.id}" noSelection="['null':'']"></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskGroup">Task Group:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskGroup','errors')}">
                                    <g:select optionKey="id" from="${TaskGroup.list()}" name="taskGroup.id" value="${taskInstance?.taskGroup?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskType">Task Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskType','errors')}">
                                    <g:select optionKey="id" from="${TaskType.list()}" name="taskType.id" value="${taskInstance?.taskType?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
