class Person {
	static transients = ['pass']
    static hasMany = [authorities: Authority,
                        personGroups: PersonGroup,
                        taskModifications: TaskModification,
                        entries: Entry,
                        tasks: Task]

    static belongsTo = [Authority, PersonGroup]

	String loginName
	String firstName
    String lastName
    String employeeID

    /* Set after login by 'welcome' action, default to 12 hours, aka "sess.setMaxInactiveInterval(seconds) */
    Integer sessionTimeout = 43200

	/** MD5 Password */
	String password

	/** enabled */
	boolean isActive = true

	String email
	boolean emailShow = true

	/** description */
	String description = ''

	/** plain password to create a MD5 password */
	String pass

	static constraints = {
		loginName(blank: false, unique: true, minSize:4)//minSize:7
		firstName(blank: false)
        lastName(blank: false)
        employeeID(blank: true, nullable:true)
        description()
        email()
        emailShow()
        isActive()
        //Enforcing minSize on password does not work since "" gets encoded to a string.
		password(blank: false)
        //So we need to use pass for validation then encode it for above.
        pass(blank: false, minSize:4)
        sessionTimeout(min:60, max:43200)

	}

    //Overriding the default toString method
    String toString() {"${this.firstName} ${this.lastName}"}
}
