import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class SubAssemblyController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ subAssemblyInstanceList: SubAssembly.list( params ), subAssemblyInstanceTotal: SubAssembly.count() ]
    }

    def show = {
        def subAssemblyInstance = SubAssembly.get( params.id )

        if(!subAssemblyInstance) {
            flash.message = "SubAssembly not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ subAssemblyInstance : subAssemblyInstance ] }
    }

    def delete = {
        def subAssemblyInstance = SubAssembly.get( params.id )
        if(subAssemblyInstance) {
            try {
                subAssemblyInstance.delete()
                flash.message = "SubAssembly ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "SubAssembly ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "SubAssembly not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def subAssemblyInstance = SubAssembly.get( params.id )

        if(!subAssemblyInstance) {
            flash.message = "SubAssembly not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ subAssemblyInstance : subAssemblyInstance ]
        }
    }

    def update = {
        def subAssemblyInstance = SubAssembly.get( params.id )
        if(subAssemblyInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(subAssemblyInstance.version > version) {
                    
                    subAssemblyInstance.errors.rejectValue("version", "subAssembly.optimistic.locking.failure", "Another user has updated this SubAssembly while you were editing.")
                    render(view:'edit',model:[subAssemblyInstance:subAssemblyInstance])
                    return
                }
            }
            subAssemblyInstance.properties = params
            if(!subAssemblyInstance.hasErrors() && subAssemblyInstance.save()) {
                flash.message = "SubAssembly ${params.id} updated"
                redirect(action:show,id:subAssemblyInstance.id)
            }
            else {
                render(view:'edit',model:[subAssemblyInstance:subAssemblyInstance])
            }
        }
        else {
            flash.message = "SubAssembly not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def subAssemblyInstance = new SubAssembly()
        subAssemblyInstance.properties = params
        return ['subAssemblyInstance':subAssemblyInstance]
    }

    def save = {
        def subAssemblyInstance = new SubAssembly(params)
        if(!subAssemblyInstance.hasErrors() && subAssemblyInstance.save()) {
            flash.message = "SubAssembly ${subAssemblyInstance.id} created"
            redirect(action:show,id:subAssemblyInstance.id)
        }
        else {
            render(view:'create',model:[subAssemblyInstance:subAssemblyInstance])
        }
    }
}
