import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class TaskPriorityController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ taskPriorityInstanceList: TaskPriority.list( params ), taskPriorityInstanceTotal: TaskPriority.count() ]
    }

    def show = {
        def taskPriorityInstance = TaskPriority.get( params.id )

        if(!taskPriorityInstance) {
            flash.message = "TaskPriority not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ taskPriorityInstance : taskPriorityInstance ] }
    }

    def delete = {
        def taskPriorityInstance = TaskPriority.get( params.id )
        if(taskPriorityInstance) {
            try {
                taskPriorityInstance.delete()
                flash.message = "TaskPriority ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "TaskPriority ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "TaskPriority not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def taskPriorityInstance = TaskPriority.get( params.id )

        if(!taskPriorityInstance) {
            flash.message = "TaskPriority not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ taskPriorityInstance : taskPriorityInstance ]
        }
    }

    def update = {
        def taskPriorityInstance = TaskPriority.get( params.id )
        if(taskPriorityInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(taskPriorityInstance.version > version) {
                    
                    taskPriorityInstance.errors.rejectValue("version", "taskPriority.optimistic.locking.failure", "Another user has updated this TaskPriority while you were editing.")
                    render(view:'edit',model:[taskPriorityInstance:taskPriorityInstance])
                    return
                }
            }
            taskPriorityInstance.properties = params
            if(!taskPriorityInstance.hasErrors() && taskPriorityInstance.save()) {
                flash.message = "TaskPriority ${params.id} updated"
                redirect(action:show,id:taskPriorityInstance.id)
            }
            else {
                render(view:'edit',model:[taskPriorityInstance:taskPriorityInstance])
            }
        }
        else {
            flash.message = "TaskPriority not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def taskPriorityInstance = new TaskPriority()
        taskPriorityInstance.properties = params
        return ['taskPriorityInstance':taskPriorityInstance]
    }

    def save = {
        def taskPriorityInstance = new TaskPriority(params)
        if(!taskPriorityInstance.hasErrors() && taskPriorityInstance.save()) {
            flash.message = "TaskPriority ${taskPriorityInstance.id} created"
            redirect(action:show,id:taskPriorityInstance.id)
        }
        else {
            render(view:'create',model:[taskPriorityInstance:taskPriorityInstance])
        }
    }
}
