import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class FrequencyController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ frequencyInstanceList: Frequency.list( params ), frequencyInstanceTotal: Frequency.count() ]
    }

    def show = {
        def frequencyInstance = Frequency.get( params.id )

        if(!frequencyInstance) {
            flash.message = "Frequency not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ frequencyInstance : frequencyInstance ] }
    }

    def delete = {
        def frequencyInstance = Frequency.get( params.id )
        if(frequencyInstance) {
            try {
                frequencyInstance.delete()
                flash.message = "Frequency ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "Frequency ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "Frequency not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def frequencyInstance = Frequency.get( params.id )

        if(!frequencyInstance) {
            flash.message = "Frequency not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ frequencyInstance : frequencyInstance ]
        }
    }

    def update = {
        def frequencyInstance = Frequency.get( params.id )
        if(frequencyInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(frequencyInstance.version > version) {
                    
                    frequencyInstance.errors.rejectValue("version", "frequency.optimistic.locking.failure", "Another user has updated this Frequency while you were editing.")
                    render(view:'edit',model:[frequencyInstance:frequencyInstance])
                    return
                }
            }
            frequencyInstance.properties = params
            if(!frequencyInstance.hasErrors() && frequencyInstance.save()) {
                flash.message = "Frequency ${params.id} updated"
                redirect(action:show,id:frequencyInstance.id)
            }
            else {
                render(view:'edit',model:[frequencyInstance:frequencyInstance])
            }
        }
        else {
            flash.message = "Frequency not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def frequencyInstance = new Frequency()
        frequencyInstance.properties = params
        return ['frequencyInstance':frequencyInstance]
    }

    def save = {
        def frequencyInstance = new Frequency(params)
        if(!frequencyInstance.hasErrors() && frequencyInstance.save()) {
            flash.message = "Frequency ${frequencyInstance.id} created"
            redirect(action:show,id:frequencyInstance.id)
        }
        else {
            render(view:'create',model:[frequencyInstance:frequencyInstance])
        }
    }
}
