

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Create Asset</title>         
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${createLinkTo(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">Asset List</g:link></span>
        </div>
        <div class="body">
            <h1>Create Asset</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${assetInstance}">
            <div class="errors">
                <g:renderErrors bean="${assetInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form action="save" method="post" >
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="assetType">Asset Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'assetType','errors')}">
                                    <g:select optionKey="id" from="${AssetType.list()}" name="assetType.id" value="${assetInstance?.assetType?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'description','errors')}">
                                    <input type="text" id="description" name="description" value="${fieldValue(bean:assetInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${assetInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="lifeplan">Lifeplan:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'lifeplan','errors')}">
                                    <g:select optionKey="id" from="${LifePlan.list()}" name="lifeplan.id" value="${assetInstance?.lifeplan?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="locationLongText">Location Long Text:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'locationLongText','errors')}">
                                    <input type="text" id="locationLongText" name="locationLongText" value="${fieldValue(bean:assetInstance,field:'locationLongText')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="manufacturedDate">Manufactured Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'manufacturedDate','errors')}">
                                    <g:datePicker name="manufacturedDate" value="${assetInstance?.manufacturedDate}" ></g:datePicker>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="modelNumber">Model Number:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'modelNumber','errors')}">
                                    <input type="text" id="modelNumber" name="modelNumber" value="${fieldValue(bean:assetInstance,field:'modelNumber')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'name','errors')}">
                                    <input type="text" id="name" name="name" value="${fieldValue(bean:assetInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="purchaseCost">Purchase Cost:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'purchaseCost','errors')}">
                                    <input type="text" id="purchaseCost" name="purchaseCost" value="${fieldValue(bean:assetInstance,field:'purchaseCost')}" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="riskPriorityNumber">Risk Priority Number:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'riskPriorityNumber','errors')}">
                                    <input type="text" id="riskPriorityNumber" name="riskPriorityNumber" value="${fieldValue(bean:assetInstance,field:'riskPriorityNumber')}" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="serialNumber">Serial Number:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'serialNumber','errors')}">
                                    <input type="text" id="serialNumber" name="serialNumber" value="${fieldValue(bean:assetInstance,field:'serialNumber')}"/>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
