import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class StoredItemController extends BaseAppAdminController  {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ storedItemInstanceList: StoredItem.list( params ), storedItemInstanceTotal: StoredItem.count() ]
    }

    def show = {
        def storedItemInstance = StoredItem.get( params.id )

        if(!storedItemInstance) {
            flash.message = "StoredItem not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ storedItemInstance : storedItemInstance ] }
    }

    def delete = {
        def storedItemInstance = StoredItem.get( params.id )
        if(storedItemInstance) {
            try {
                storedItemInstance.delete()
                flash.message = "StoredItem ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "StoredItem ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "StoredItem not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def storedItemInstance = StoredItem.get( params.id )

        if(!storedItemInstance) {
            flash.message = "StoredItem not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ storedItemInstance : storedItemInstance ]
        }
    }

    def update = {
        def storedItemInstance = StoredItem.get( params.id )
        if(storedItemInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(storedItemInstance.version > version) {
                    
                    storedItemInstance.errors.rejectValue("version", "storedItem.optimistic.locking.failure", "Another user has updated this StoredItem while you were editing.")
                    render(view:'edit',model:[storedItemInstance:storedItemInstance])
                    return
                }
            }
            storedItemInstance.properties = params
            if(!storedItemInstance.hasErrors() && storedItemInstance.save()) {
                flash.message = "StoredItem ${params.id} updated"
                redirect(action:show,id:storedItemInstance.id)
            }
            else {
                render(view:'edit',model:[storedItemInstance:storedItemInstance])
            }
        }
        else {
            flash.message = "StoredItem not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def storedItemInstance = new StoredItem()
        storedItemInstance.properties = params
        return ['storedItemInstance':storedItemInstance]
    }

    def save = {
        def storedItemInstance = new StoredItem(params)
        if(!storedItemInstance.hasErrors() && storedItemInstance.save()) {
            flash.message = "StoredItem ${storedItemInstance.id} created"
            redirect(action:show,id:storedItemInstance.id)
        }
        else {
            render(view:'create',model:[storedItemInstance:storedItemInstance])
        }
    }
}
