import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class InventoryTypeController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ inventoryTypeInstanceList: InventoryType.list( params ), inventoryTypeInstanceTotal: InventoryType.count() ]
    }

    def show = {
        def inventoryTypeInstance = InventoryType.get( params.id )

        if(!inventoryTypeInstance) {
            flash.message = "InventoryType not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ inventoryTypeInstance : inventoryTypeInstance ] }
    }

    def delete = {
        def inventoryTypeInstance = InventoryType.get( params.id )
        if(inventoryTypeInstance) {
            try {
                inventoryTypeInstance.delete()
                flash.message = "InventoryType ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "InventoryType ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "InventoryType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def inventoryTypeInstance = InventoryType.get( params.id )

        if(!inventoryTypeInstance) {
            flash.message = "InventoryType not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ inventoryTypeInstance : inventoryTypeInstance ]
        }
    }

    def update = {
        def inventoryTypeInstance = InventoryType.get( params.id )
        if(inventoryTypeInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(inventoryTypeInstance.version > version) {
                    
                    inventoryTypeInstance.errors.rejectValue("version", "inventoryType.optimistic.locking.failure", "Another user has updated this InventoryType while you were editing.")
                    render(view:'edit',model:[inventoryTypeInstance:inventoryTypeInstance])
                    return
                }
            }
            inventoryTypeInstance.properties = params
            if(!inventoryTypeInstance.hasErrors() && inventoryTypeInstance.save()) {
                flash.message = "InventoryType ${params.id} updated"
                redirect(action:show,id:inventoryTypeInstance.id)
            }
            else {
                render(view:'edit',model:[inventoryTypeInstance:inventoryTypeInstance])
            }
        }
        else {
            flash.message = "InventoryType not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def inventoryTypeInstance = new InventoryType()
        inventoryTypeInstance.properties = params
        return ['inventoryTypeInstance':inventoryTypeInstance]
    }

    def save = {
        def inventoryTypeInstance = new InventoryType(params)
        if(!inventoryTypeInstance.hasErrors() && inventoryTypeInstance.save()) {
            flash.message = "InventoryType ${inventoryTypeInstance.id} created"
            redirect(action:show,id:inventoryTypeInstance.id)
        }
        else {
            render(view:'create',model:[inventoryTypeInstance:inventoryTypeInstance])
        }
    }
}
