class Department {

    String name
    String description = ""
    String comment = ""
    boolean isActive = true

    static hasMany = [sections: Section,
                                departmentExtendedAttributes: DepartmentExtendedAttribute,
                                persons: Person]

//     static belongsTo = []

    static constraints = {
        name(maxSize:50, unique:true, blank:false)
        description(maxSize:75)
        comment(maxSize:500)
        isActive()
    }

    String toString() {
        "${this.name}"
    }
}

