import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager'])
class SectionDetailedController extends BaseController {

    def sectionService

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def index = { redirect(action:list,params:params) }

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ sectionInstanceList: Section.list( params ), sectionInstanceTotal: Section.count() ]
    }

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def show = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Show)
            params.action='show'

        def sectionInstance = Section.get( params.id )

        if(!sectionInstance) {
            flash.message = "Section not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ sectionInstance : sectionInstance ] }
    }

    @Secured(['ROLE_AppAdmin'])
    def delete = {
        def result = sectionService.delete(params)

        if(!result.error) {
            flash.message = g.message(code: "default.delete.success", args: ["Section", params.id])
            redirect(action:list)
            return
        }

        flash.errorMessage = g.message(code: result.error.code, args: result.error.args)

        if(result.error.code == "default.not.found") {
            redirect(action:list)
            return
        }

        redirect(action:show, id: params.id)
    }

    def edit = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Edit)
            params.action='edit'

        def sectionInstance = Section.get( params.id )

        if(!sectionInstance) {
            flash.message = "Section not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ sectionInstance : sectionInstance ]
        }
    }

    def update = {
        def sectionInstance = Section.get( params.id )
        if(sectionInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(sectionInstance.version > version) {
                    
                    sectionInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[sectionInstance:sectionInstance])
                    return
                }
            }
            sectionInstance.properties = params
            if(!sectionInstance.hasErrors() && sectionInstance.save(flush: true)) {
                flash.message = "Section ${params.id} updated"
                redirect(action:show,id:sectionInstance.id)
            }
            else {
                render(view:'edit',model:[sectionInstance:sectionInstance])
            }
        }
        else {
            flash.message = "Section not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def sectionInstance = new Section()
        sectionInstance.properties = params
        return ['sectionInstance':sectionInstance]
    }

    def save = {
        def sectionInstance = new Section(params)
        if(!sectionInstance.hasErrors() && sectionInstance.save(flush: true)) {
            flash.message = "Section ${sectionInstance.id} created"
            redirect(action:show,id:sectionInstance.id)
        }
        else {
            render(view:'create',model:[sectionInstance:sectionInstance])
        }
    }
}
