import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager'])
class PurchasingGroupDetailedController extends BaseController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ purchasingGroupInstanceList: PurchasingGroup.list( params ), purchasingGroupInstanceTotal: PurchasingGroup.count() ]
    }

    def show = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Show)
            params.action='show'

        def purchasingGroupInstance = PurchasingGroup.get( params.id )

        if(!purchasingGroupInstance) {
            flash.message = "PurchasingGroup not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ purchasingGroupInstance : purchasingGroupInstance ] }
    }

    def delete = {
        def purchasingGroupInstance = PurchasingGroup.get( params.id )
        if(purchasingGroupInstance) {
            try {
                purchasingGroupInstance.delete(flush:true)
                flash.message = "PurchasingGroup ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "PurchasingGroup ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "PurchasingGroup not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Edit)
            params.action='edit'

        def purchasingGroupInstance = PurchasingGroup.get( params.id )

        if(!purchasingGroupInstance) {
            flash.message = "PurchasingGroup not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ purchasingGroupInstance : purchasingGroupInstance ]
        }
    }

    def update = {
        def purchasingGroupInstance = PurchasingGroup.get( params.id )
        if(purchasingGroupInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(purchasingGroupInstance.version > version) {
                    
                    purchasingGroupInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[purchasingGroupInstance:purchasingGroupInstance])
                    return
                }
            }
            purchasingGroupInstance.properties = params
            if(!purchasingGroupInstance.hasErrors() && purchasingGroupInstance.save(flush: true)) {
                flash.message = "PurchasingGroup ${params.id} updated"
                redirect(action:show,id:purchasingGroupInstance.id)
            }
            else {
                render(view:'edit',model:[purchasingGroupInstance:purchasingGroupInstance])
            }
        }
        else {
            flash.message = "PurchasingGroup not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def purchasingGroupInstance = new PurchasingGroup()
        purchasingGroupInstance.properties = params
        return ['purchasingGroupInstance':purchasingGroupInstance]
    }

    def save = {
        def purchasingGroupInstance = new PurchasingGroup(params)
        if(!purchasingGroupInstance.hasErrors() && purchasingGroupInstance.save(flush: true)) {
            flash.message = "PurchasingGroup ${purchasingGroupInstance.id} created"
            redirect(action:show,id:purchasingGroupInstance.id)
        }
        else {
            render(view:'create',model:[purchasingGroupInstance:purchasingGroupInstance])
        }
    }
}
