
// Depends on jQuery.

// Add a child by cloning a template and appending to wrapper element.
// Used with a parent and LazyList of children (One-to-Many).
// Since javascript has no pointers the childCount source var must be incremented by the calling code.
// @param wrapperId The id of the wrapper element, e.g: div or tbody.
// @param cloneId The id of the element to clone.
// @param lazyList The name of the LazyList.
// @param fields A list of fields in the clone that need name and id set.
// @param focusField Which field in the fields list to focus on after adding.
// @param childCount The current child count, used to set LazyList index, remember to increment!
function addChild(wrapperId, cloneId, lazyList, fields, focusField, childCount){

    var clone = jQuery("#"+cloneId).clone();
    clone.attr('id', lazyList+childCount);
    var htmlId = lazyList+'['+childCount+'].';

    var fieldsMap = {};
    jQuery.each(fields, function(index, field) {
        fieldsMap[field] = clone.find('[id$="'+field+'"]');
        fieldsMap[field].attr('id',htmlId + field)
                                    .attr('name',htmlId + field);
    });

    jQuery("#"+wrapperId).append(clone);
    clone.show();
    fieldsMap[focusField].focus();
}