import org.apache.commons.collections.list.LazyList
import org.apache.commons.collections.FactoryUtils

class TaskProcedure {

    Task linkedTask

    def getDescription() { linkedTask.description }
    def getAsset() { linkedTask.primaryAsset }

    List maintenanceActions = new ArrayList()

    static hasMany = [tasks: Task, maintenanceActions: MaintenanceAction]

    def getMaintenanceActionLazyList() {
        return LazyList.decorate(maintenanceActions, FactoryUtils.instantiateFactory(MaintenanceAction.class))
    }

    static mappedBy = [tasks:"taskProcedure"]

    static mapping = {
        maintenanceActions cascade:"all-delete-orphan"
    }

//     static belongsTo = []

    static constraints = {
    }

    String toString() {
        "${this.id}"
    }
}
