package com.henyo

import grails.test.GrailsUnitTestCase
import org.springframework.transaction.TransactionStatus

/**
 * Base unit test class with mock extensions.
 * http://blog.henyo.com/2009/04/mocking-transactions-for-unit-testing.html
 */ 
class BaseUnitTestCase extends GrailsUnitTestCase {

    def statusControls

    protected void setUp() {
        super.setUp()
        statusControls = []
    }

    protected void tearDown(){
        statusControls.each{
            it.verify()
        }
        statusControls.clear()
        super.tearDown()
    }

    def mockForTransaction(Class clazz,boolean expectRollback = false){
        registerMetaClass(clazz)
        def statusControl = mockFor(TransactionStatus)
        statusControls << statusControl
        if(expectRollback)
            statusControl.demand.setRollbackOnly(1..1) { println 'setRollbackOnly called'}
        def status = statusControl.createMock()
        clazz.metaClass.'static'.withTransaction = {
            Closure callable ->  callable.call(status)
        }
        return statusControl
    }
}
