import geb.spock.GebReportingSpec
import gnumims.functional.pages.HomePage
import gnumims.functional.pages.LoginPage

/**
 * Provides a base class for functional testing.
 * Significantly speedup functional test development:
 *  Run `grails test run-app`.
 *  In a separate process run `grails interactive`
 *  At the prompt `test-app functional: -baseUrl=http://localhost:8080/gnuMims -echoOut`
 *  Hit enter to repeat tests very quickly.
 */
class GebReportingSpecBase extends GebReportingSpec {
    def appName = grails.util.Metadata.current.'app.name'
    String getBaseUrl() { "http://localhost:8080/$appName/" }
    File getReportDir() { new File("target/test-reports/geb-pages") }

    /**
     * Logs into the application either via a target page that requires
     * authentication or by directly requesting the login page.
     */
    def login(username, password, targetPage = null, params = [:]) {
        if (targetPage) {
            to([*:params], targetPage)
            page LoginPage
        }
        else {
            to LoginPage
        }

        form.j_username = username
        form.j_password = password

        //if (targetPage) login.click(targetPage)
        if (targetPage) loginButton.click(HomePage) // gnuMims will always start at HomePage.
        else loginButton.click(HomePage)
    }
}
