

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Create AssignedPerson</title>
    </head>
    <body>
        <div class="nav">
            <h1>Create Assigned Person</h1>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${assignedPersonInstance}">
            <div class="errors">
                <g:renderErrors bean="${assignedPersonInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form action="save" method="post" >
                <g:hiddenField name="task.id" value="${assignedPersonInstance?.task?.id}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="task">Task:</label>
                                </td>
                                <td valign="top" class="name">
                                    <g:link controller="taskDetailed" action="show" id="${assignedPersonInstance.task.id}" >
                                        ${assignedPersonInstance?.task.encodeAsHTML()}
                                    </g:link>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="person">Person:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assignedPersonInstance,field:'person','errors')}">
                                    <g:select optionKey="id"
                                                        from="${Person.list().sort { p1, p2 -> p1.firstName.compareToIgnoreCase(p2.firstName) }}"
                                                        name="person.id"
                                                        value="${assignedPersonInstance?.person?.id}"
                                                        onchange="${remoteFunction(action:'groupsForPerson', update:'groupsForPerson', params: '\'person.id=\' + this.value' )}">
                                    </g:select>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="durationHour">Estimated Duration:</label>
                                </td>

                                <td valign="top" class="value">
                                    <input class="time ${hasErrors(bean:assignedPersonInstance,field:'estimatedHour','errors')}" 
                                        type="text" id="estimatedHour" name="estimatedHour" 
                                        value="${fieldValue(bean:assignedPersonInstance,field:'estimatedHour')}" />
                                    :
                                    <input class="time ${hasErrors(bean:assignedPersonInstance,field:'estimatedMinute','errors')}" 
                                        type="text" id="estimatedMinute" name="estimatedMinute" 
                                        value="${fieldValue(bean:assignedPersonInstance,field:'estimatedMinute')}" />
                                    <g:helpBalloon code="assignedPerson.estimatedDuration" />
                                </td> 
                            </tr>
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:form>

            <br />

            <div id="groupsForPerson" class="dialog">
                <g:render template="groupsForPerson" />
            </div>

        </div>
    </body>
</html>
