

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Create InventoryMovement</title>
    </head>
    <body>
        <div class="nav">
            <h1>Create Inventory Movement</h1>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${inventoryMovementInstance}">
            <div class="errors">
                <g:renderErrors bean="${inventoryMovementInstance}" as="list" />
            </div>
            </g:hasErrors>

            <g:form action="save" method="post" >
                <g:hiddenField name="inventoryItem.id" value="${inventoryMovementInstance?.inventoryItem?.id}" />
                <div class="dialog">
                    <table>
                        <tbody>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryItem">Inventory Item:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryMovementInstance,field:'inventoryItem','errors')}">
                                    <g:link controller="inventoryItemDetailed" action="show" id="${inventoryMovementInstance?.inventoryItem?.id}" >
                                        <g:fieldValue bean="${inventoryMovementInstance}" field="inventoryItem" />
                                    </g:link>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="quantity">Quantity:</label>
                                </td>
                                <td valign="top">
                                    <input class="medium ${hasErrors(bean:inventoryMovementInstance,field:'quantity','errors')}"
                                                type="text" id="quantity" name="quantity"
                                                value="${fieldValue(bean:inventoryMovementInstance,field:'quantity')}"/>
                                                ${inventoryMovementInstance?.inventoryItem?.unitOfMeasure.encodeAsHTML()}
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryMovementType">Movement Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryMovementInstance,field:'inventoryMovementType','errors')}">
                                    <g:select optionKey="id" from="${inventoryMovementTypeList}" name="inventoryMovementType.id" value="${inventoryMovementInstance?.inventoryMovementType?.id}" ></g:select>
                                </td>
                            </tr>

                            <g:if test="${inventoryMovementInstance?.task}">
                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="taskInstance">Linking with task:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <g:hiddenField name="task.id" value="${inventoryMovementInstance.task.id}" />
                                        <g:link controller="taskDetailed" action="show" id="${inventoryMovementInstance.task.id}" >
                                            ${inventoryMovementInstance.task.encodeAsHTML()}
                                        </g:link>
                                    </td>
                                </tr>
                            </g:if>

                        </tbody>
                    </table>
                </div>

                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>

            </g:form>
        </div>
    </body>
</html>
