/*
 * Decompiled with CFR 0.152.
 */
package org.openxri;

import com.ibm.icu.text.UTF16;
import org.openxri.Characters;
import org.openxri.IRIUtils;
import org.openxri.Parsable;
import org.openxri.ParseStream;
import org.openxri.XRef;

public class SubSegment
extends Parsable {
    boolean mbPersistant = false;
    XRef moXRef = null;
    boolean mbAllowColon = false;
    boolean mbAllowImpliedDelimiter = false;

    SubSegment(boolean bAllowImpliedDelimiter, boolean bAllowColon) {
        this.mbAllowImpliedDelimiter = bAllowImpliedDelimiter;
        this.mbAllowColon = bAllowColon;
    }

    public SubSegment(String sXRI) {
        super(sXRI);
        this.parse();
    }

    public SubSegment(String sXRI, boolean bAllowColon) {
        super(sXRI);
        this.mbAllowColon = bAllowColon;
        this.parse();
    }

    public boolean isPersistant() {
        return this.mbPersistant;
    }

    public XRef getXRef() {
        this.parse();
        return this.moXRef;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean wantOptionalDelim) {
        this.parse();
        String sRetval = super.toString();
        if (sRetval.length() > 0 && sRetval.charAt(0) != '*' && sRetval.charAt(0) != '!' && wantOptionalDelim) {
            sRetval = "*" + sRetval;
        }
        return sRetval;
    }

    public boolean equals(SubSegment subseg) {
        return this.toString(true).equals(subseg.toString(true));
    }

    public boolean equalsIgnoreCase(SubSegment subseg) {
        return this.toString(true).equalsIgnoreCase(subseg.toString(true));
    }

    boolean doScan(ParseStream oStream) {
        if (oStream.getData().charAt(0) == '!') {
            this.mbPersistant = true;
            oStream.consume(1);
        } else if (oStream.getData().charAt(0) == '*') {
            oStream.consume(1);
        } else if (!this.mbAllowImpliedDelimiter) {
            return false;
        }
        XRef oXRef = new XRef();
        if (oXRef.scan(oStream)) {
            this.moXRef = oXRef;
            return true;
        }
        int n = this.scanPChars(oStream.getData());
        oStream.consume(n);
        return true;
    }

    private int scanPChars(String s) {
        int c;
        for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)c)) {
            c = UTF16.charAt((String)s, (int)i);
            if (Characters.isPChar(c) && (c != 58 || this.mbAllowColon)) continue;
            if (Characters.isEscaped(c, s, i)) {
                i += 2;
                continue;
            }
            return i;
        }
        return s.length();
    }

    public String toIRINormalForm() {
        return this.toIRINormalForm(true);
    }

    public String toIRINormalForm(boolean wantOptionalDelim) {
        if (this.moXRef != null) {
            String sValue = this.isPersistant() ? "!" : (wantOptionalDelim ? "*" : "");
            return sValue + this.moXRef.toIRINormalForm();
        }
        return IRIUtils.XRItoIRI(this.toString(wantOptionalDelim), false);
    }

    public String toURINormalForm() {
        return this.toURINormalForm(true);
    }

    public String toURINormalForm(boolean wantOptionalDelim) {
        return IRIUtils.IRItoURI(this.toIRINormalForm(wantOptionalDelim));
    }
}

