/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Metric {
    DAILY_ACTIVE_USERS("daily_active_users"),
    ACTIVE_USERS("active_users"),
    UNIQUE_ADDS("unique_adds"),
    UNIQUE_REMOVES("unique_removes"),
    UNIQUE_BLOCKS("unique_blocks"),
    UNIQUE_UNBLOCKS("unique_unblocks"),
    API_CALLS("api_calls"),
    UNIQUE_API_CALLS("unique_api_calls"),
    CANVAS_PAGE_VIEWS("canvas_page_views"),
    UNIQUE_CANVAS_PAGE_VIEWS("unique_canvas_page_views"),
    REQUEST_TIME_AVG("canvas_http_request_time_avg"),
    FBML_RENDER_TIME_AVG("canvas_fbml_render_time_avg"),
    REQUEST_TIMEOUT("canvas_page_views_http_code_0"),
    REQUEST_CONTINUE("canvas_page_views_http_code_100"),
    REQUEST_OK("canvas_page_views_http_code_200"),
    REQUEST_OK_NO_DATA("canvas_page_views_http_code_200ND"),
    REQUEST_ERROR_301("canvas_page_views_http_code_301"),
    REQUEST_ERROR_302("canvas_page_views_http_code_302"),
    REQUEST_ERROR_303("canvas_page_views_http_code_303"),
    REQUEST_ERROR_400("canvas_page_views_http_code_400"),
    REQUEST_ERROR_401("canvas_page_views_http_code_401"),
    REQUEST_ERROR_403("canvas_page_views_http_code_403"),
    REQUEST_ERROR_404("canvas_page_views_http_code_404"),
    REQUEST_ERROR_405("canvas_page_views_http_code_405"),
    REQUEST_ERROR_413("canvas_page_views_http_code_413"),
    REQUEST_ERROR_422("canvas_page_views_http_code_422"),
    REQUEST_ERROR_500("canvas_page_views_http_code_500"),
    REQUEST_ERROR_502("canvas_page_views_http_code_502"),
    REQUEST_ERROR_503("canvas_page_views_http_code_503"),
    REQUEST_ERROR_505("canvas_page_views_http_code_505");

    public static final Long PERIOD_DAY;
    public static final Long PERIOD_WEEK;
    public static final Long PERIOD_MONTH;
    private String name;
    protected static final Map<String, Metric> METRIC_TABLE;

    private Metric(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Metric getMetric(String name) {
        return METRIC_TABLE.get(name);
    }

    public static Metric getErrorMetric(int errorCode) {
        return METRIC_TABLE.get("canvas_page_views_http_code_" + Integer.toString(errorCode));
    }

    static {
        PERIOD_DAY = 86400L;
        PERIOD_WEEK = 604800L;
        PERIOD_MONTH = 2592000L;
        METRIC_TABLE = new HashMap<String, Metric>();
        for (Metric metric : Metric.values()) {
            METRIC_TABLE.put(metric.getName(), metric);
        }
    }
}

