/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.openid.consumers;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.openid4java.association.AssociationException;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.MessageException;
import org.openid4java.message.ParameterList;
import org.springframework.security.providers.openid.OpenIDAuthenticationStatus;
import org.springframework.security.providers.openid.OpenIDAuthenticationToken;
import org.springframework.security.ui.openid.OpenIDConsumer;
import org.springframework.security.ui.openid.OpenIDConsumerException;

public class OpenID4JavaConsumer
implements OpenIDConsumer {
    private final ConsumerManager consumerManager;
    static /* synthetic */ Class class$org$openid4java$discovery$DiscoveryInformation;

    public OpenID4JavaConsumer(ConsumerManager consumerManager) {
        this.consumerManager = consumerManager;
    }

    public OpenID4JavaConsumer() throws ConsumerException {
        this(new ConsumerManager());
    }

    public String beginConsumption(HttpServletRequest req, String identityUrl, String returnToUrl) throws OpenIDConsumerException {
        return this.beginConsumption(req, identityUrl, returnToUrl, returnToUrl);
    }

    public String beginConsumption(HttpServletRequest req, String identityUrl, String returnToUrl, String realm) throws OpenIDConsumerException {
        AuthRequest authReq;
        List discoveries;
        try {
            discoveries = this.consumerManager.discover(identityUrl);
        }
        catch (DiscoveryException e) {
            throw new OpenIDConsumerException("Error during discovery", e);
        }
        DiscoveryInformation information = this.consumerManager.associate(discoveries);
        HttpSession session = req.getSession(true);
        session.setAttribute((class$org$openid4java$discovery$DiscoveryInformation == null ? (class$org$openid4java$discovery$DiscoveryInformation = OpenID4JavaConsumer.class$("org.openid4java.discovery.DiscoveryInformation")) : class$org$openid4java$discovery$DiscoveryInformation).getName(), (Object)information);
        try {
            authReq = this.consumerManager.authenticate(information, returnToUrl, realm);
        }
        catch (MessageException e) {
            throw new OpenIDConsumerException("Error processing ConumerManager authentication", e);
        }
        catch (ConsumerException e) {
            throw new OpenIDConsumerException("Error processing ConumerManager authentication", e);
        }
        return authReq.getDestinationUrl(true);
    }

    public OpenIDAuthenticationToken endConsumption(HttpServletRequest request) throws OpenIDConsumerException {
        VerificationResult verification;
        ParameterList openidResp = new ParameterList(request.getParameterMap());
        DiscoveryInformation discovered = (DiscoveryInformation)request.getSession().getAttribute((class$org$openid4java$discovery$DiscoveryInformation == null ? (class$org$openid4java$discovery$DiscoveryInformation = OpenID4JavaConsumer.class$("org.openid4java.discovery.DiscoveryInformation")) : class$org$openid4java$discovery$DiscoveryInformation).getName());
        StringBuffer receivingURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null && queryString.length() > 0) {
            receivingURL.append("?").append(request.getQueryString());
        }
        try {
            verification = this.consumerManager.verify(receivingURL.toString(), openidResp, discovered);
        }
        catch (MessageException e) {
            throw new OpenIDConsumerException("Error verifying openid response", e);
        }
        catch (DiscoveryException e) {
            throw new OpenIDConsumerException("Error verifying openid response", e);
        }
        catch (AssociationException e) {
            throw new OpenIDConsumerException("Error verifying openid response", e);
        }
        Identifier verified = verification.getVerifiedId();
        if (verified != null) {
            return new OpenIDAuthenticationToken(OpenIDAuthenticationStatus.SUCCESS, verified.getIdentifier(), "some message");
        }
        return new OpenIDAuthenticationToken(OpenIDAuthenticationStatus.FAILURE, discovered.getClaimedIdentifier().getIdentifier(), "Verification status message: [" + verification.getStatusMsg() + "]");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

