/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acl.basic;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.acl.basic.AclObjectIdentity;
import org.springframework.security.acl.basic.BasicAclEntry;
import org.springframework.util.Assert;

public abstract class AbstractBasicAclEntry
implements BasicAclEntry {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$acl$basic$AbstractBasicAclEntry == null ? (class$org$springframework$security$acl$basic$AbstractBasicAclEntry = AbstractBasicAclEntry.class$("org.springframework.security.acl.basic.AbstractBasicAclEntry")) : class$org$springframework$security$acl$basic$AbstractBasicAclEntry));
    private AclObjectIdentity aclObjectIdentity;
    private AclObjectIdentity aclObjectParentIdentity;
    private Object recipient;
    private int[] validPermissions;
    private int mask = 0;
    static /* synthetic */ Class class$org$springframework$security$acl$basic$AbstractBasicAclEntry;

    public AbstractBasicAclEntry(Object recipient, AclObjectIdentity aclObjectIdentity, AclObjectIdentity aclObjectParentIdentity, int mask) {
        Assert.notNull((Object)recipient, (String)"recipient cannot be null");
        Assert.notNull((Object)aclObjectIdentity, (String)"aclObjectIdentity cannot be null");
        this.validPermissions = this.getValidPermissions();
        Arrays.sort(this.validPermissions);
        for (int i = 0; i < this.validPermissions.length; ++i) {
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Valid permission:   " + this.printPermissionsBlock(this.validPermissions[i]) + " " + this.printBinary(this.validPermissions[i]) + " (" + this.validPermissions[i] + ")"));
        }
        this.recipient = recipient;
        this.aclObjectIdentity = aclObjectIdentity;
        this.aclObjectParentIdentity = aclObjectParentIdentity;
        this.mask = mask;
    }

    protected AbstractBasicAclEntry() {
        this.validPermissions = this.getValidPermissions();
        Arrays.sort(this.validPermissions);
    }

    public int addPermission(int permissionToAdd) {
        return this.addPermissions(new int[]{permissionToAdd});
    }

    public int addPermissions(int[] permissionsToAdd) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("BEFORE Permissions: " + this.printPermissionsBlock(this.mask) + " " + this.printBinary(this.mask) + " (" + this.mask + ")"));
        }
        for (int i = 0; i < permissionsToAdd.length; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add     permission: " + this.printPermissionsBlock(permissionsToAdd[i]) + " " + this.printBinary(permissionsToAdd[i]) + " (" + permissionsToAdd[i] + ")"));
            }
            this.mask |= permissionsToAdd[i];
        }
        if (Arrays.binarySearch(this.validPermissions, this.mask) < 0) {
            throw new IllegalArgumentException("Resulting permission set will be invalid.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AFTER  Permissions: " + this.printPermissionsBlock(this.mask) + " " + this.printBinary(this.mask) + " (" + this.mask + ")"));
        }
        return this.mask;
    }

    public int deletePermission(int permissionToDelete) {
        return this.deletePermissions(new int[]{permissionToDelete});
    }

    public int deletePermissions(int[] permissionsToDelete) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("BEFORE Permissions: " + this.printPermissionsBlock(this.mask) + " " + this.printBinary(this.mask) + " (" + this.mask + ")"));
        }
        for (int i = 0; i < permissionsToDelete.length; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Delete  permission: " + this.printPermissionsBlock(permissionsToDelete[i]) + " " + this.printBinary(permissionsToDelete[i]) + " (" + permissionsToDelete[i] + ")"));
            }
            this.mask &= ~permissionsToDelete[i];
        }
        if (Arrays.binarySearch(this.validPermissions, this.mask) < 0) {
            throw new IllegalArgumentException("Resulting permission set will be invalid.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AFTER  Permissions: " + this.printPermissionsBlock(this.mask) + " " + this.printBinary(this.mask) + " (" + this.mask + ")"));
        }
        return this.mask;
    }

    public AclObjectIdentity getAclObjectIdentity() {
        return this.aclObjectIdentity;
    }

    public AclObjectIdentity getAclObjectParentIdentity() {
        return this.aclObjectParentIdentity;
    }

    public int getMask() {
        return this.mask;
    }

    public Object getRecipient() {
        return this.recipient;
    }

    public abstract int[] getValidPermissions();

    public boolean isPermitted(int permissionToCheck) {
        return this.isPermitted(this.mask, permissionToCheck);
    }

    protected boolean isPermitted(int maskToCheck, int permissionToCheck) {
        return (maskToCheck & permissionToCheck) == permissionToCheck;
    }

    private String printBinary(int i) {
        String s = Integer.toString(i, 2);
        String pattern = "................................";
        String temp1 = pattern.substring(0, pattern.length() - s.length());
        String temp2 = temp1 + s;
        return temp2.replace('0', '.');
    }

    public abstract String printPermissionsBlock(int var1);

    public String printPermissionsBlock() {
        return this.printPermissionsBlock(this.mask);
    }

    public void setAclObjectIdentity(AclObjectIdentity aclObjectIdentity) {
        this.aclObjectIdentity = aclObjectIdentity;
    }

    public void setAclObjectParentIdentity(AclObjectIdentity aclObjectParentIdentity) {
        this.aclObjectParentIdentity = aclObjectParentIdentity;
    }

    public void setMask(int mask) {
        this.mask = mask;
    }

    public void setRecipient(Object recipient) {
        this.recipient = recipient;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[").append(this.aclObjectIdentity).append(",").append(this.recipient);
        sb.append("=").append(this.printPermissionsBlock(this.mask)).append(" ");
        sb.append(this.printBinary(this.mask)).append(" (");
        sb.append(this.mask).append(")").append("]");
        return sb.toString();
    }

    public int togglePermission(int permissionToToggle) {
        this.mask ^= permissionToToggle;
        if (Arrays.binarySearch(this.validPermissions, this.mask) < 0) {
            throw new IllegalArgumentException("Resulting permission set will be invalid.");
        }
        return this.mask;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

