/*
 * Decompiled with CFR 0.152.
 */
package org.openxri;

import org.openxri.AuthorityPath;
import org.openxri.SubSegment;
import org.openxri.XRI;
import org.openxri.XRISegment;

public abstract class XRIAuthority
extends AuthorityPath {
    XRISegment moSegment;

    XRIAuthority() {
    }

    XRIAuthority(String sPath) {
        super(sPath);
        this.parse();
    }

    public XRISegment getXRISegment() {
        this.parse();
        return this.moSegment;
    }

    public int getNumSubSegments() {
        this.parse();
        if (this.moSegment != null) {
            return this.moSegment.getNumSubSegments();
        }
        return 0;
    }

    public SubSegment getSubSegmentAt(int nIndex) {
        this.parse();
        if (this.moSegment != null) {
            return this.moSegment.getSubSegmentAt(nIndex);
        }
        return null;
    }

    public SubSegment getLastSubSegment() {
        int nSize;
        this.parse();
        if (this.moSegment != null && (nSize = this.moSegment.getNumSubSegments()) >= 1) {
            return this.moSegment.getSubSegmentAt(nSize - 1);
        }
        return null;
    }

    public abstract String getRootAuthority();

    public abstract XRIAuthority getParent();

    public XRI getParentAsXRI() {
        XRIAuthority oParent = this.getParent();
        return oParent == null ? null : new XRI(oParent);
    }
}

