/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authoritymapping;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authoritymapping.MappableAttributesRetriever;
import org.springframework.util.Assert;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XmlMappableAttributesRetriever
implements MappableAttributesRetriever,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$authoritymapping$XmlMappableAttributesRetriever == null ? (class$org$springframework$security$authoritymapping$XmlMappableAttributesRetriever = XmlMappableAttributesRetriever.class$("org.springframework.security.authoritymapping.XmlMappableAttributesRetriever")) : class$org$springframework$security$authoritymapping$XmlMappableAttributesRetriever));
    private String[] mappableAttributes = null;
    private InputStream xmlInputStream = null;
    private String xpathExpression = null;
    private boolean closeInputStream = true;
    static /* synthetic */ Class class$org$springframework$security$authoritymapping$XmlMappableAttributesRetriever;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.xmlInputStream, (String)"An XML InputStream must be set");
        Assert.notNull((Object)this.xpathExpression, (String)"An XPath expression must be set");
        this.mappableAttributes = this.getMappableAttributes(this.xmlInputStream);
    }

    public String[] getMappableAttributes() {
        String[] copy = new String[this.mappableAttributes.length];
        System.arraycopy(this.mappableAttributes, 0, copy, 0, copy.length);
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getMappableAttributes(InputStream aStream) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Reading mappable attributes from XML document");
        }
        try {
            Document doc = this.getDocument(aStream);
            String[] roles = this.getMappableAttributes(doc);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Mappable attributes from XML document: " + Arrays.asList(roles)));
            }
            String[] stringArray = roles;
            return stringArray;
        }
        finally {
            if (this.closeInputStream) {
                try {
                    aStream.close();
                }
                catch (Exception e) {
                    logger.debug((Object)"Input stream could not be closed", (Throwable)e);
                }
            }
        }
    }

    private Document getDocument(InputStream aStream) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder db = factory.newDocumentBuilder();
            db.setEntityResolver(new MyEntityResolver());
            Document doc = db.parse(new IgnoreCloseInputStream(aStream));
            return doc;
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException("Unable to parse document object", e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Unable to parse document object", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to parse document object", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse document object", e);
        }
    }

    private String[] getMappableAttributes(Document doc) {
        try {
            DOMXPath xpath = new DOMXPath(this.xpathExpression);
            List roleElements = xpath.selectNodes((Object)doc);
            String[] roles = new String[roleElements.size()];
            for (int i = 0; i < roles.length; ++i) {
                roles[i] = ((Node)roleElements.get(i)).getNodeValue();
            }
            return roles;
        }
        catch (JaxenException e) {
            throw new RuntimeException("Unable to retrieve mappable roles", e);
        }
        catch (DOMException e) {
            throw new RuntimeException("Unable to retrieve mappable roles", e);
        }
    }

    protected void setXmlInputStream(InputStream aStream) {
        this.xmlInputStream = aStream;
    }

    protected void setXpathExpression(String anXpathExpression) {
        this.xpathExpression = anXpathExpression;
    }

    public void setCloseInputStream(boolean b) {
        this.closeInputStream = b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class IgnoreCloseInputStream
    extends FilterInputStream {
        public IgnoreCloseInputStream(InputStream stream) {
            super(stream);
        }

        public void close() throws IOException {
        }
    }

    private static final class MyEntityResolver
    implements EntityResolver {
        private MyEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    }
}

