/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.securechannel;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.security.securechannel.ChannelDecisionManager;
import org.springframework.security.securechannel.ChannelProcessor;
import org.springframework.util.Assert;

public class ChannelDecisionManagerImpl
implements ChannelDecisionManager,
InitializingBean {
    public static final String ANY_CHANNEL = "ANY_CHANNEL";
    private List channelProcessors;
    static /* synthetic */ Class class$org$springframework$security$securechannel$ChannelProcessor;

    public void afterPropertiesSet() throws Exception {
        this.checkIfValidList(this.channelProcessors);
    }

    private void checkIfValidList(List listToCheck) {
        Assert.notEmpty((Collection)listToCheck, (String)"A list of ChannelProcessors is required");
    }

    public void decide(FilterInvocation invocation, ConfigAttributeDefinition config) throws IOException, ServletException {
        Iterator attrs = config.getConfigAttributes().iterator();
        while (attrs.hasNext()) {
            ConfigAttribute attribute = (ConfigAttribute)attrs.next();
            if (!ANY_CHANNEL.equals(attribute.getAttribute())) continue;
            return;
        }
        Iterator iter = this.channelProcessors.iterator();
        while (iter.hasNext()) {
            ChannelProcessor processor = (ChannelProcessor)iter.next();
            processor.decide(invocation, config);
            if (!invocation.getResponse().isCommitted()) continue;
            break;
        }
    }

    protected List getChannelProcessors() {
        return this.channelProcessors;
    }

    public void setChannelProcessors(List newList) {
        this.checkIfValidList(newList);
        Iterator iter = newList.iterator();
        while (iter.hasNext()) {
            Object currentObject = iter.next();
            Assert.isInstanceOf((Class)(class$org$springframework$security$securechannel$ChannelProcessor == null ? ChannelDecisionManagerImpl.class$("org.springframework.security.securechannel.ChannelProcessor") : class$org$springframework$security$securechannel$ChannelProcessor), currentObject, (String)("ChannelProcessor " + currentObject.getClass().getName() + " must implement ChannelProcessor"));
        }
        this.channelProcessors = newList;
    }

    public boolean supports(ConfigAttribute attribute) {
        if (ANY_CHANNEL.equals(attribute.getAttribute())) {
            return true;
        }
        Iterator iter = this.channelProcessors.iterator();
        while (iter.hasNext()) {
            ChannelProcessor processor = (ChannelProcessor)iter.next();
            if (!processor.supports(attribute)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

