/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.easymock.internal.Invocation;
import org.easymock.internal.MockInvocationHandler;

public class ObjectMethodsFilter
implements InvocationHandler {
    private final Method equalsMethod;
    private final Method hashCodeMethod;
    private final Method toStringMethod;
    private final MockInvocationHandler delegate;
    private final String name;

    public ObjectMethodsFilter(Class toMock, MockInvocationHandler delegate, String name) {
        if (name != null && !Invocation.isJavaIdentifier(name)) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid Java identifier.", name));
        }
        try {
            if (toMock.isInterface()) {
                toMock = Object.class;
            }
            this.equalsMethod = toMock.getMethod("equals", Object.class);
            this.hashCodeMethod = toMock.getMethod("hashCode", null);
            this.toStringMethod = toMock.getMethod("toString", null);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("An Object method could not be found!");
        }
        this.delegate = delegate;
        this.name = name;
    }

    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.equalsMethod.equals(method)) {
            return proxy == args[0];
        }
        if (this.hashCodeMethod.equals(method)) {
            return new Integer(System.identityHashCode(proxy));
        }
        if (this.toStringMethod.equals(method)) {
            return this.mockToString(proxy);
        }
        return this.delegate.invoke(proxy, method, args);
    }

    private String mockToString(Object proxy) {
        return this.name != null ? this.name : "EasyMock for " + this.mockType(proxy);
    }

    private String mockType(Object proxy) {
        if (Proxy.isProxyClass(proxy.getClass())) {
            return proxy.getClass().getInterfaces()[0].toString();
        }
        return proxy.getClass().getSuperclass().toString();
    }

    public MockInvocationHandler getDelegate() {
        return this.delegate;
    }
}

