/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.encoding;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.springframework.security.providers.encoding.BaseDigestPasswordEncoder;
import org.springframework.security.providers.encoding.Md4;

public class Md4PasswordEncoder
extends BaseDigestPasswordEncoder {
    public String encodePassword(String rawPass, Object salt) {
        byte[] passBytes;
        String saltedPass = this.mergePasswordAndSalt(rawPass, salt, false);
        try {
            passBytes = saltedPass.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 not supported!");
        }
        Md4 md4 = new Md4();
        md4.update(passBytes, 0, passBytes.length);
        byte[] resBuf = md4.digest();
        if (this.getEncodeHashAsBase64()) {
            return new String(Base64.encodeBase64((byte[])resBuf));
        }
        return new String(Hex.encodeHex((byte[])resBuf));
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        String pass1 = "" + encPass;
        String pass2 = this.encodePassword(rawPass, salt);
        return pass1.equals(pass2);
    }

    public String getAlgorithm() {
        return "MD4";
    }
}

