/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.transaction.compensating.manager;

import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.transaction.compensating.TempEntryRenamingStrategy;
import org.springframework.ldap.transaction.compensating.manager.ContextSourceTransactionManagerDelegate;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSuspensionNotSupportedException;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class ContextSourceAndDataSourceTransactionManager
extends DataSourceTransactionManager {
    private static final long serialVersionUID = 6832868697460384648L;
    private ContextSourceTransactionManagerDelegate ldapManagerDelegate = new ContextSourceTransactionManagerDelegate();

    public ContextSourceAndDataSourceTransactionManager() {
        this.setNestedTransactionAllowed(false);
    }

    protected boolean isExistingTransaction(Object transaction) {
        ContextSourceAndDataSourceTransactionObject actualTransactionObject = (ContextSourceAndDataSourceTransactionObject)transaction;
        return super.isExistingTransaction(actualTransactionObject.getDataSourceTransactionObject());
    }

    protected Object doGetTransaction() throws TransactionException {
        Object dataSourceTransactionObject = super.doGetTransaction();
        Object contextSourceTransactionObject = this.ldapManagerDelegate.doGetTransaction();
        return new ContextSourceAndDataSourceTransactionObject(contextSourceTransactionObject, dataSourceTransactionObject);
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        ContextSourceAndDataSourceTransactionObject actualTransactionObject = (ContextSourceAndDataSourceTransactionObject)transaction;
        super.doBegin(actualTransactionObject.getDataSourceTransactionObject(), definition);
        this.ldapManagerDelegate.doBegin(actualTransactionObject.getLdapTransactionObject(), definition);
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        ContextSourceAndDataSourceTransactionObject actualTransactionObject = (ContextSourceAndDataSourceTransactionObject)transaction;
        super.doCleanupAfterCompletion(actualTransactionObject.getDataSourceTransactionObject());
        this.ldapManagerDelegate.doCleanupAfterCompletion(actualTransactionObject.getLdapTransactionObject());
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        ContextSourceAndDataSourceTransactionObject actualTransactionObject = (ContextSourceAndDataSourceTransactionObject)status.getTransaction();
        try {
            super.doCommit(new DefaultTransactionStatus(actualTransactionObject.getDataSourceTransactionObject(), status.isNewTransaction(), status.isNewSynchronization(), status.isReadOnly(), status.isDebug(), status.getSuspendedResources()));
        }
        catch (TransactionException ex) {
            if (this.isRollbackOnCommitFailure()) {
                this.logger.debug((Object)"Failed to commit db resource, rethrowing", (Throwable)ex);
                throw ex;
            }
            this.logger.warn((Object)"Failed to commit and resource is rollbackOnCommit not set - proceeding to commit ldap resource.");
        }
        this.ldapManagerDelegate.doCommit(new DefaultTransactionStatus(actualTransactionObject.getLdapTransactionObject(), status.isNewTransaction(), status.isNewSynchronization(), status.isReadOnly(), status.isDebug(), status.getSuspendedResources()));
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        ContextSourceAndDataSourceTransactionObject actualTransactionObject = (ContextSourceAndDataSourceTransactionObject)status.getTransaction();
        super.doRollback(new DefaultTransactionStatus(actualTransactionObject.getDataSourceTransactionObject(), status.isNewTransaction(), status.isNewSynchronization(), status.isReadOnly(), status.isDebug(), status.getSuspendedResources()));
        this.ldapManagerDelegate.doRollback(new DefaultTransactionStatus(actualTransactionObject.getLdapTransactionObject(), status.isNewTransaction(), status.isNewSynchronization(), status.isReadOnly(), status.isDebug(), status.getSuspendedResources()));
    }

    public ContextSource getContextSource() {
        return this.ldapManagerDelegate.getContextSource();
    }

    public void setContextSource(ContextSource contextSource) {
        this.ldapManagerDelegate.setContextSource(contextSource);
    }

    protected void setRenamingStrategy(TempEntryRenamingStrategy renamingStrategy) {
        this.ldapManagerDelegate.setRenamingStrategy(renamingStrategy);
    }

    protected Object doSuspend(Object transaction) throws TransactionException {
        throw new TransactionSuspensionNotSupportedException("Transaction manager [" + ((Object)((Object)this)).getClass().getName() + "] does not support transaction suspension");
    }

    protected void doResume(Object transaction, Object suspendedResources) throws TransactionException {
        throw new TransactionSuspensionNotSupportedException("Transaction manager [" + ((Object)((Object)this)).getClass().getName() + "] does not support transaction suspension");
    }

    private class ContextSourceAndDataSourceTransactionObject {
        private Object ldapTransactionObject;
        private Object dataSourceTransactionObject;

        public ContextSourceAndDataSourceTransactionObject(Object ldapTransactionObject, Object dataSourceTransactionObject) {
            this.ldapTransactionObject = ldapTransactionObject;
            this.dataSourceTransactionObject = dataSourceTransactionObject;
        }

        public Object getDataSourceTransactionObject() {
            return this.dataSourceTransactionObject;
        }

        public Object getLdapTransactionObject() {
            return this.ldapTransactionObject;
        }
    }
}

