/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.core;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.ldap.core.LdapEncoder;

public class LdapRdnComponent
implements Comparable,
Serializable {
    private static final long serialVersionUID = -3296747972616243038L;
    public static final boolean DONT_DECODE_VALUE = false;
    private String key;
    private String value;
    static /* synthetic */ Class class$org$springframework$ldap$core$LdapRdnComponent;

    public LdapRdnComponent(String key, String value) {
        this(key, value, false);
    }

    public LdapRdnComponent(String key, String value, boolean decodeValue) {
        Validate.notEmpty((String)key, (String)"Key must not be empty");
        Validate.notEmpty((String)value, (String)"Value must not be empty");
        this.key = StringUtils.lowerCase((String)key);
        this.value = decodeValue ? LdapEncoder.nameDecode(value) : value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    protected String encodeLdap() {
        StringBuffer buff = new StringBuffer(this.key.length() + this.value.length() * 2);
        buff.append(this.key);
        buff.append('=');
        buff.append(LdapEncoder.nameEncode(this.value));
        return buff.toString();
    }

    public String toString() {
        return this.getLdapEncoded();
    }

    public String getLdapEncoded() {
        return this.encodeLdap();
    }

    public String encodeUrl() {
        try {
            URI valueUri = new URI(null, null, this.value, null);
            return this.key + "=" + valueUri.toString();
        }
        catch (URISyntaxException e) {
            return this.key + "=" + "value";
        }
    }

    public int hashCode() {
        return this.key.hashCode() ^ this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == (class$org$springframework$ldap$core$LdapRdnComponent == null ? (class$org$springframework$ldap$core$LdapRdnComponent = LdapRdnComponent.class$("org.springframework.ldap.core.LdapRdnComponent")) : class$org$springframework$ldap$core$LdapRdnComponent)) {
            LdapRdnComponent that = (LdapRdnComponent)obj;
            return StringUtils.equalsIgnoreCase((String)this.key, (String)that.key) && StringUtils.equalsIgnoreCase((String)this.value, (String)that.value);
        }
        return false;
    }

    public int compareTo(Object obj) {
        LdapRdnComponent that = (LdapRdnComponent)obj;
        return this.toString().compareTo(that.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

