/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class X509CertificateResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$keys$keyresolver$implementations$X509CertificateResolver == null ? (class$org$apache$xml$security$keys$keyresolver$implementations$X509CertificateResolver = X509CertificateResolver.class$("org.apache.xml.security.keys.keyresolver.implementations.X509CertificateResolver")) : class$org$apache$xml$security$keys$keyresolver$implementations$X509CertificateResolver).getName());
    Element[] _x509CertKeyElements = null;
    XMLX509Certificate[] _x509certObject = null;
    static /* synthetic */ Class class$org$apache$xml$security$keys$keyresolver$implementations$X509CertificateResolver;

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Can I resolve " + element.getTagName() + "?"));
        }
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            log.debug((Object)"I can't");
            return false;
        }
        this._x509CertKeyElements = XMLUtils.selectDsNodes(element.getFirstChild(), "X509Certificate");
        if (this._x509CertKeyElements != null && this._x509CertKeyElements.length > 0) {
            log.debug((Object)"Yes Sir, I can");
            return true;
        }
        log.debug((Object)"I can't");
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        try {
            int n;
            if (!(this._x509CertKeyElements != null && this._x509CertKeyElements.length != 0 || (n = this.engineCanResolve(element, string, storageResolver)) != 0 && this._x509CertKeyElements != null && this._x509CertKeyElements.length != 0)) {
                return null;
            }
            this._x509certObject = new XMLX509Certificate[this._x509CertKeyElements.length];
            for (n = 0; n < this._x509CertKeyElements.length; ++n) {
                this._x509certObject[n] = new XMLX509Certificate(this._x509CertKeyElements[n], string);
            }
            for (n = 0; n < this._x509certObject.length; ++n) {
                X509Certificate x509Certificate = this._x509certObject[n].getX509Certificate();
                if (x509Certificate == null) continue;
                return x509Certificate;
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.debug((Object)"XMLSecurityException", (Throwable)xMLSecurityException);
            throw new KeyResolverException("generic.EmptyMessage", xMLSecurityException);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

